/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "DialogManager.hh"
#include "MasterDialog.hh"

DialogManager::DialogManager(top10::tracked::MainEditor* main_e,
			     top10::tracked::MeshEditor* mesh_e,
			     top10::tracked::SurfacesEditor* surf_e,
			     top10::tracked::DecorationsEditor* deco_e,
			     top10::tracked::CheckpointsEditor* cps_e,
			     top10::tracked::StartingAreaEditor* sa_e):
  main_ed(main_e), mesh_ed(mesh_e), surf_ed(surf_e), deco_ed(deco_e), cps_ed(cps_e), sa_ed(sa_e),
  active(true)
{
  main_ed->showEditorData(top10::tracked::Mesh);
  master = new MasterDialog(this);
  master->install();
  master->show();
  current_dialog = master;
}

void DialogManager::toggleActive()
{
  if (active) {
    active = false;
    current_dialog->hide();
  }
  else {
    active = true;
    current_dialog->show();
  }
}

void DialogManager::setCurrentDialog(std::string dialog_name)
{
  Dialog* new_dialog;
  if (dialog_name == "Master") {
    new_dialog = master;
  }
  else {
    DialogRegister::iterator f = dialogs.find(dialog_name);
    if (f == dialogs.end()) throw BadDialogName(dialog_name);
    new_dialog = f->second;
  }
  if (new_dialog != current_dialog) {
    current_dialog->remove();
    current_dialog = new_dialog;
    current_dialog->install();
    if (active) current_dialog->show();
    else current_dialog->hide();
  }
}

void DialogManager::registerDialog(Dialog* new_dialog)
{
  if (new_dialog->getName() == "Master") throw AlreadyRegistered(new_dialog->getName());
  if (dialogs.find(new_dialog->getName()) != dialogs.end()) throw AlreadyRegistered(new_dialog->getName());
  dialogs[new_dialog->getName()] = new_dialog;

  current_dialog->remove();
  current_dialog->install();
  if (active) current_dialog->show();
}
