/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_SURFACEEDITOR_HH
#define TOP10_TRACKED_SURFACEEDITOR_HH

#include <string>
#include <set>
#include "Drawable.hh"
#include "SurfaceTypeEnum.hh"
#include "MeshEditor.hh"
#include "graphX/DepthOffsetNode.hh"
#include "graphX/AlphaNode.hh"

namespace top10 {
  namespace tracked {

    class SurfacesEditor : public Drawable {
    public:
      SurfacesEditor();
      
      void setMeshEditor(MeshEditor* p);
      void reset();

      inline void setCurrentSurfaceType(SurfaceTypeEnum surf_type) { current_surface_type = surf_type; }
      inline SurfaceTypeEnum getCurrentSurfaceType() const { return current_surface_type; }
      inline void setCurrentSurface(std::string name) { current_surface_name = name; }
      inline std::string getCurrentSurface() const { return current_surface_name; }

      //! Return the surfaces associated to the current surface type
      std::set<std::string> getCurrentSurfaceSet() const;
      //! Set the current surface name to the one under the reticle
      void pick();
      //! Add the current surface name to this surface type
      void add();
      void remove();

    public:
      std::set<std::string> road_surfaces;
      std::set<std::string> dusty_road_surfaces;
      std::set<std::string> border_surfaces;
      std::set<std::string> grass_surfaces;
      std::set<std::string> sand_surfaces;
      std::set<std::string> dirt_surfaces;

    private:
      SurfaceTypeEnum current_surface_type;
      std::string current_surface_name;

      std::set<std::string>* surfaces[6];
      MeshEditor* mesh_ed;

    private:
      top10::util::Ref<top10::graphX::Node> proxy_node;
      top10::util::Ref<top10::graphX::DepthOffsetNode> offset_node;
      top10::util::Ref<top10::graphX::AlphaNode> alpha_node;
    };

  };
};

#endif //SURFACEEDITOR_H

