/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACKEDSURFACETYPEPROXYNODE_HH
#define TOP10_TRACKEDSURFACETYPEPROXYNODE_HH

#include "graphX/NodeProxy.hh"
#include "SurfacesEditor.hh"

namespace top10 {
namespace tracked {

/*! MeshNodes are replaced by material nodes whose only child is the original MeshNode */
class SurfaceTypeProxyOperation: public top10::graphX::ProxyOperation {
public:
  SurfaceTypeProxyOperation(const SurfacesEditor* surf_ed): surf_ed(surf_ed) {}
  
  top10::graphX::Node* makeChild(const top10::graphX::MeshNode*) const;
  
private:
  const SurfacesEditor* surf_ed;
  
  //! The alternate colors to use for each surface type
  static const unsigned char rs[6];
  static const unsigned char gs[6];
  static const unsigned char bs[6];
};

}
}

#endif
