/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_SURFACETYPEENUM_HH
#define TOP10_TRACKED_SURFACETYPEENUM_HH

#include <cassert>

namespace top10 {
  namespace tracked {
    enum SurfaceTypeEnum {
      Road=0, DustyRoad=1, Border=2, Grass=3, Sand=4, Dirt=5
    };

    static const char* surfaceTypeNames[] = {
      "Road", "Dusty road", "Border", "Grass", "Sand", "Dirt", 0
    };

    inline const char* toSurfaceTypeName(int n) {
      assert(n>=0);
      assert(n<=5);
      return surfaceTypeNames[n];
    }

    inline SurfaceTypeEnum toSurfaceTypeEnum(int n) {
      switch(n) {
      case 0: return Road;
      case 1: return DustyRoad;
      case 2: return Border;
      case 3: return Grass;
      case 4: return Sand;
      case 5: return Dirt;
      default: assert(false);
      }
    }
  };
};

#endif

