/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_MESHEDITOR_HH
#define TOP10_TRACKED_MESHEDITOR_HH

#include <string>
#include <cassert>

#include "math/AxisEnum.hh"
#include "graphX/TransformNode.hh"
#include "MainCamera.hh"
#include "Drawable.hh"


namespace top10 {
  namespace tracked {
    class MeshEditor : public Drawable {
    public:
      MeshEditor();
      ~MeshEditor();
      
      inline void setCamera(MainCamera* c) { camera = c; }

      void reset();

      /**
       * Load a mesh for the ground from a file
       * @param filename 
       */
      void loadMesh(std::string filename);
      std::string getFilename() const { return model_filename; }
      inline float getScaling() const { return scaling; }
      inline void setScaling(float f) { scaling = f; updateTransform(); }
      inline top10::math::AxisEnum getAxis() const { return axis; }
      inline void setAxis(top10::math::AxisEnum ax) { axis = ax; updateTransform(); }
      inline bool getAxisNegate() const { return axis_negate; }
      inline void setAxisNegate(bool b) { axis_negate = b; updateTransform(); }
      
      std::string getPickedSurface() const;
      std::string getPickedMesh() const;
      top10::math::Vector getPickedPoint() const;
      void updateTransform();
      
      inline top10::graphX::Node* getMeshNode() const { return mesh_node.getPtr(); }
      inline top10::graphX::TransformNode* getTransformNode() const { return transform_node.getPtr(); }
      
    private:
      std::string model_filename;
      float scaling;
      top10::math::AxisEnum axis;
      bool axis_negate;

    private:
      top10::util::Ref<top10::graphX::Node> mesh_node;
      top10::util::Ref<top10::graphX::TransformNode> transform_node;
      top10::util::Ref<MainCamera> camera;
    };
  };
};

#endif

