/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_MAINEDITOR_HH
#define TOP10_TRACKED_MAINEDITOR_HH

#include "Drawable.hh"
#include "EditorEnum.hh"
#include "MeshEditor.hh"
#include "DecorationsEditor.hh"
#include "StartingAreaEditor.hh"
#include "CheckpointsEditor.hh"
#include "SurfacesEditor.hh"

namespace top10 {
  namespace tracked {
    class MainEditor: public Drawable {
    public:
      MainEditor();

      inline void setMeshEditor(MeshEditor* p) { mesh_ed = p; }
      inline void setDecorationsEditor(DecorationsEditor* p) { deco_ed = p; }
      inline void setStartingAreaEditor(StartingAreaEditor* p) { start_ed = p; }
      inline void setCheckpointsEditor(CheckpointsEditor* p) { cps_ed = p; }
      inline void setSurfacesEditor(SurfacesEditor* p) { surf_ed = p; }

      //! Load a track file
      void loadTrack(std::string filename);

      //! Save the edited track to a file
      void saveTrack(std::string filename);

      /**
       * Show the data being edited by a particular editor
       * @param editor 
       */
      void showEditorData(EditorEnum editor);
  
      /**
       * Hide the data of a specific editor
       * @param editor 
       */
      void hideEditorData(EditorEnum editor);
      
    private:
      MeshEditor* mesh_ed;
      DecorationsEditor* deco_ed;
      StartingAreaEditor* start_ed;
      CheckpointsEditor* cps_ed;
      SurfacesEditor* surf_ed;
    };
  };
};

#endif //MAINEDITOR_H

