/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "DecorationsEditor.hh"
#include "DecorationProxyOperation.hh"
#include "graphX/NodeProxy.hh"

using namespace top10::tracked;

DecorationsEditor::DecorationsEditor(): mesh_ed(0)
{
  alpha_node = new top10::graphX::AlphaNode;
  alpha_node->setAlpha(128);
  getNode()->addChild(alpha_node.getPtr());
  
  offset_node = new top10::graphX::DepthOffsetNode;
  offset_node->setOffset(-1.0);
  alpha_node->addChild(offset_node.getPtr());
  
  reset();
}

void DecorationsEditor::setMeshEditor(MeshEditor* p)
{
  mesh_ed = p;
  offset_node->removeChild(proxy_node.getPtr());
  proxy_node = new top10::graphX::TransformNodeProxy(p->getTransformNode(), new DecorationProxyOperation(this));
  offset_node->addChild(proxy_node.getPtr());
}

void DecorationsEditor::reset()
{
  current_mesh.clear();
}

void DecorationsEditor::pick()
{
  assert(mesh_ed);

  current_mesh = mesh_ed->getPickedMesh();
}

void DecorationsEditor::add()
{
  if (current_mesh.empty()) throw std::string("Select a mesh to add first");
  decorations.insert(current_mesh);
}

void DecorationsEditor::remove()
{
  if (current_mesh.empty()) throw std::string("Select a mesh to remove first");
  std::set<std::string>::iterator f = decorations.find(current_mesh);
  if (f == decorations.end()) throw std::string("Cannot remove mesh: ")+current_mesh;
  decorations.erase(f);
}
