/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_COMPLEX_OBJECT_HH
#define TOP10_COMPLEX_OBJECT_HH

#include "math/Box.hh"
#include "math/Triangle.hh"
#include "util/RefCount.hh"

namespace top10 {
  namespace physX {

    class World;

    //Should be called PhysicObject
    class ComplexObject: public top10::util::RefCount {
    public:
      ComplexObject(): is_active(false) {}
      
      virtual ~ComplexObject() {}
      
      /// Register itself to a world
      /**
	 When registered to a world, an object starts interacting with a
	 world and its content.
      */
      virtual void getRegistered(World& world) =0;

      //! Perform collision detection with the track and its response
      virtual void collideTrack(double dt) =0;

      //! Perform collision detection and response with non-track fixed objects
      virtual void handleCollisions(const std::vector<top10::math::Triangle>& polyset, double dt) =0;
      
      //! Update object's acceleration and speed
      /*!
	 \param dt the amount of time elapsed since last time update was called.
      */
      virtual void update(double G, double dt) =0;

      //! Move the object according to accelerations and speeds computed in update()
      virtual void integrate(double dt) =0;

      //! Return the bounding box for this object.
      virtual top10::math::Box getBoundingBox() const =0;
      
      inline void setActive(bool b) { is_active = b; }
      inline bool isActive() const { return is_active; }
      
    private:
      bool is_active;
    };
  };
};

#endif
