/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include <cmath>
#include "Base.hh"

using namespace top10::math;

void Base::pointTo(const Vector& direction, const Vector& up)
{
  Vector X,Y,Z;
  Z = direction;
  double Zs = Z.size();
  if (Zs > SMALL_VECTOR) {
    Z/=Zs;
    Y = up;
    X = (Y^Z);
    double Xs = X.size();
    if (Xs > SMALL_VECTOR) {
      x = X/Xs;
      z = Z;
      y = z^x;
    }
    else {
      std::cerr<<"Base::pointTo: up and direction are parallel"<<std::endl;
    }
  }
  else {
    std::cerr<<"Base::pointTo: direction is too small"<<std::endl;
  }
}

void Base::getToBase(double out[4][4]) const
{
  out[0][0] = x.x; out[1][0] = x.y; out[2][0] = x.z; out[3][0] = 0;
  out[0][1] = y.x; out[1][1] = y.y; out[2][1] = y.z; out[3][1] = 0;
  out[0][2] = z.x; out[1][2] = z.y; out[2][2] = z.z; out[3][2] = 0;
  out[0][3] = 0;   out[1][3] = 0;   out[2][3] = 0;   out[3][3] = 1.0;    
}

void Base::getFromBase(double out[4][4]) {
  out[0][0] = x.x; out[1][0] = y.x; out[2][0] = z.x; out[3][0] = 0;
  out[0][1] = x.y; out[1][1] = y.y; out[2][1] = z.y; out[3][1] = 0;
  out[0][2] = x.z; out[1][2] = y.z; out[2][2] = z.z; out[3][2] = 0;
  out[0][3] = 0;   out[1][3] = 0;   out[2][3] = 0;   out[3][3] = 1.0;
}

void Base::rotateX(double angle)
{
  Vector y2 = y*cos(angle) + z*sin(angle);
  Vector z2 = z*cos(angle) - y*sin(angle);
  y = y2;
  z = z2;
}

void Base::rotateY(double angle)
{
  Vector z2 = z*cos(angle) + x*sin(angle);
  Vector x2 = x*cos(angle) - z*sin(angle);
  x = x2;
  z = z2;
}

void Base::rotateZ(double angle)
{
  Vector x2 = x*cos(angle) + y*sin(angle);
  Vector y2 = y*cos(angle) - x*sin(angle);
  y = y2;
  x = x2;
}

void Base::dumpTo(std::ostream& str) const
{
  x.dumpTo(str);
  y.dumpTo(str);
  z.dumpTo(str);

  pos.dumpTo(str);
}

void Base::loadFrom(std::istream& str)
{
  x.loadFrom(str);
  y.loadFrom(str);
  z.loadFrom(str);

  pos.loadFrom(str);
}
