#include "OrientMatrix.hh"

using top10::math::Vector;
using top10::math::Matrix3;
using top10::math::Matrix4;
using top10::math::AxisEnum;

static Matrix3 makeRotate(AxisEnum axis, bool negative)
{
  Vector e[3];

  switch(axis) {
  case top10::math::X:
    e[0] = Vector(0, 1, 0);
    e[1] = Vector(0, 0, 1);
    e[2] = Vector(1, 0, 0);
    break;
  case top10::math::Y:
    e[0] = Vector(1, 0, 0);
    e[1] = Vector(0, 1, 0);
    e[2] = Vector(0, 0, 1);
    break;
  case top10::math::Z:
    e[0] = Vector(0, 0, 1);
    e[1] = Vector(1, 0, 0);
    e[2] = Vector(0, 1, 0);
    break;
  }
  if (negative) {
    for (int i = 0; i<3; ++i)
      e[i] = -e[i];
  }
  Matrix3 tmpM3(e);
  return tmpM3;
}

Matrix4 top10::helpers::makeOrientation(AxisEnum axis, bool negative, double scale)
{
  Matrix3 tmpM3 = makeRotate(axis, negative);
  Matrix4 tmpM4(scale*tmpM3);

  return tmpM4;
}

Matrix4 top10::helpers::makeInverse(AxisEnum axis, bool negative, double scale)
{
  Matrix3 M3 = makeRotate(axis, negative).transpose();
  Matrix4 M4(M3/scale);
  
  return M4;
}
