/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "TextureManager.hh"
extern "C" {
#include "extras/sdl2gl.h"
}
#include <SDL/SDL_image.h>
#include "util/PathFinder.hh"

namespace top10 {
namespace graphX {

TextureManager* TextureManager::singleton = 0;

TextureManager* TextureManager::getInstance()
{
  if (singleton) return singleton;
  else return (singleton = new TextureManager);
}

TextureManager::TextureManager()
{
}

unsigned int TextureManager::getTexture(std::string name)
{
  std::map<std::string, unsigned int>::const_iterator f = name_to_id.find(name);
  if (f != name_to_id.end()) return f->second;
  
  // Texture does not exist yet, load it
  std::string path = top10::util::PathFinder::defaultPathFinder().find(name);
  SDL_Surface* surface = IMG_Load(path.c_str());
  if (surface == 0) {
    name_to_id[ top10::util::PathFinder::basename(name) ] = 0;
    return 0;
  } else {
    unsigned int id = createGLfromSDL(surface, 0, 0);
    name_to_id[ top10::util::PathFinder::basename(name) ] = id;
    SDL_FreeSurface(surface);
    return id;
  }
  
  return 0;
}

}
}
