/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_NODE_ITERATOR_HH
#define TOP10_GRAPHX_NODE_ITERATOR_HH

#include "Node.hh"
#include "LeafNode.hh"
#include <vector>

namespace top10 {
  namespace graphX {
        
    //! Iterate over nodes in a scene graph depth-first
    class DFSNodeIterator {
    public:
      DFSNodeIterator(Node*);
      
      DFSNodeIterator& operator++();
      Node* operator*() const;
      bool atEnd() const;
      
    protected:
      std::vector< std::pair<Node*, int> > pos;
    };
        
    //! Iterate over the leaves of a sub-graph, gathering transforms along paths
    class LeafNodeIterator: private DFSNodeIterator {
    public:
      LeafNodeIterator(Node*);
      
      LeafNodeIterator& operator++();
      Node* operator*() const;
      top10::math::Matrix4 getTransform() const;
      bool atEnd() const;
      
    private:
      bool onLeaf() const;
    };
    
  };
};

#endif

