/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_MESHNODE_HH
#define TOP10_GRAPHX_MESHNODE_HH

#include "math/Mesh.hh"
#include "LeafNode.hh"
#include <vector>

namespace top10 {
  namespace graphX {

    //! Extends math::Mesh with texture mapping and normals
    class MeshNode: public LeafNode {
    public:
      //! Coordinates in a 2d texture
      struct TextureCoord {
	double s, t;
      };

    public:
      /*!
	\param mesh pointer to the triangles
	\param normals array of normals
	\param normal_idxs indices into the normal array. Three for each triangle.
	\param tex_coords array of texture coordinates. 3 for each triangle.
      */
      MeshNode(const top10::math::Mesh* mesh,
	       std::vector<top10::math::Vector> normals,
	       std::vector<int> normal_idxs,
	       std::vector<TextureCoord> tex_coords,
               std::string name);

      //! Compute smooth normals automatically
      MeshNode(const top10::math::Mesh* mesh,
	       std::vector<TextureCoord> tex_coords,
               std::string name);

      void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const;

      inline const std::vector<top10::math::Vector>* getNormals() const { return &normals; }
      inline const std::vector<TextureCoord>* getTexCoords() const { return &tex_coords; }
      inline const std::vector<int>* getNormalIndices() const { return &normal_idxs; }
      inline const top10::math::Mesh* getMesh() const { return mesh; }
      inline void setMaterialName(std::string n) { mat_name = n; }
      inline std::string getMaterialName() const { return mat_name; }
      
    private:
      std::string mat_name;
      const top10::math::Mesh* mesh;
      std::vector<top10::math::Vector> normals;
      //! Three for each triangle
      std::vector<TextureCoord> tex_coords;
      //! Three for each triangle
      std::vector<int> normal_idxs;
    };
  };
};

#endif
