/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_LEAF_NODE_HH
#define TOP10_GRAPHX_LEAF_NODE_HH

#include "Node.hh"
#include <vector>
#include <cassert>

namespace top10 {
  namespace graphX {
    class LeafNode: public Node {
    public:
      LeafNode() {}

      inline void buildRenderList(RenderState s, RenderList* rl) const { rl->insert(std::make_pair(s, this)); }
      inline Node* getChild(int) const { return 0; }
      inline void addChild(Node*) { }
      inline void removeChild(Node*) { }
      inline void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const {}
    };
  };
};
#endif
