/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "IntersectionFinder.hh"
#include "TransformNode.hh"
#include "math/intersections.hh"

namespace top10 {
namespace graphX {

using top10::math::Ray;
  
void IntersectionFinder::find(Node* node, Ray r)
{
  MeshNode* mesh_node = dynamic_cast<MeshNode*>(node);
  if (mesh_node) {
    double d;
    top10::util::Ref<MeshNode> rf(mesh_node);
    if (top10::math::intersect(*mesh_node->getMesh(), r, &d)) res[d] = rf;
  } else {
    TransformNode* transform = dynamic_cast<TransformNode*>(node);
    if (transform) r.transform(transform->fromWorld());
    for_all_children(node, child)
      find(child, r); 
    for_all_children_end;
  }
}


}
}
