/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "GridNode.hh"

namespace top10 {
namespace graphX {

GridNode::GridNode():top10::graphX::LeafNode()
{
}

void GridNode::buildRenderList(RenderState s, RenderList* l) const
{
  l->insert(std::make_pair(s, this));
}

void GridNode::renderGL(const RenderingFeatures& unused, const RenderState&, const CameraNode&) const
{
  for (int x=-100; x<=100; x+=5) {
    glBegin(GL_LINES);
    
    glVertex3f(x, 0, -100);
    glVertex3f(x, 0, 100);
    
    glVertex3f(-100, 0, x);
    glVertex3f(100, 0, x);
    
    glEnd();
  }
}

}
}
