#include "Range.hh"
#include <cassert>

using top10::util::Range;

Range::Range()
{
}

Range::Range(int first, int last)
{
  if (first <= last)
    units.push_front( std::make_pair(first, last) );
}

void Range::insert(int first, int last)
{
  if (first > last) return;

  std::list< std::pair< int, int> >::const_iterator pu;
  std::list< std::pair< int, int> > new_units;

  for (pu = units.begin(); pu != units.end() && pu->second < first; ++pu) {
    new_units.push_back(*pu);
  }

  std::pair< int, int> new_unit(first, last);
  for (; pu != units.end() && pu->first <= last; ++pu) {
    if (pu->first < new_unit.first) new_unit.first = pu->first;
    if (pu->second > new_unit.second) new_unit.second = pu->second;
  }
  new_units.push_back(new_unit);

  for (; pu != units.end(); ++pu) new_units.push_back(*pu);

  units.swap(new_units);
}

void Range::remove(int first, int last)
{
  if (first > last) return;

  std::list< std::pair< int, int> >::const_iterator pu;
  std::list< std::pair< int, int> > new_units;

  for (pu = units.begin(); pu != units.end() && pu->second < first; ++pu) {
    new_units.push_back(*pu);
  }

  for (;pu != units.end() && pu->first <= last; ++pu) {
    std::pair< int, int> new_unit1(0, -1);
    std::pair< int, int> new_unit2(0, -1);

    if (pu->first <= first) {
      new_unit1.first = pu->first;
      new_unit1.second = first-1;
    }
    if (last <= pu->second) {
      new_unit2.first = last+1;
      new_unit2.second = pu->second;
    }
    if (new_unit1.first <= new_unit1.second) new_units.push_back(new_unit1);
    if (new_unit2.first <= new_unit2.second) new_units.push_back(new_unit2);
  }

  for (;pu != units.end(); ++pu) new_units.push_back(*pu);

  units.swap(new_units);
}

Range::const_iterator Range::begin() const
{
  const_iterator ret;
  ret.range = this;
  ret.p_unit = units.begin();
  if (units.empty()) ret.val = 0;
  else ret.val = ret.p_unit->first;

  return ret;
}

Range::const_iterator Range::end() const
{
  const_iterator ret;
  ret.range = this;
  ret.p_unit = units.end();
  ret.val = 0;

  return ret;
}

Range::const_iterator& Range::const_iterator::operator++()
{
  if (p_unit == range->units.end()) abort();

  if (val == p_unit->second) {
    ++p_unit;
    if (p_unit != range->units.end()) val = p_unit->first;
    else val = 0;
  }
  else {
    ++val;
  }

  return *this;
}

Range::const_iterator& Range::const_iterator::operator--()
{
  if (p_unit == range->units.begin() && (p_unit == range->units.end() || val == p_unit->first)) abort();

  if (val == p_unit->first) {
    --p_unit;
    val = p_unit->second;
  }
  else {
    --val;
  }

  return *this;
}

int Range::const_iterator::operator*() const
{
  assert(!operator==(range->end()));
  return val;
}

// consts are cheap today!!!
bool Range::const_iterator::operator==(const const_iterator& other) const
{
  return range == other.range && p_unit == other.p_unit && val == other.val;
}
