/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UI_TRIANGLE_HH
#define TOP10_UI_TRIANGLE_HH

#include <vector>
#include <map>

#include <GL/gl.h>

#include "physX/Triangle.hh"
#include "helpers/PolygonSet.hh"
#include "physX/Octree.hh"
#include "Frustum.hh"

namespace top10 {
  namespace ui_interactive {

    struct Texture
    {
      /// GL name of texture
      GLuint tex_name;
      /// Is GL texture used ?
      bool tex_used;

      /* For the track editor, it can be convenient to visualize texture usage.
	 To achieve this, the texture is "replaced" by a solid color */
      bool alt_used;
      unsigned char r,g,b;
    };

    /// A mesh of coloured triangles.
    struct TriangleSet
    {
      TriangleSet(top10::helpers::PolygonSet*);
      TriangleSet(): polygons(0), listname(0), octree(0) {};
      ~TriangleSet();

      void buildOctree() const;
      inline const top10::physX::Octree* getOctree() const { if (octree==0) octree = new top10::physX::Octree(polygons); return octree; }
      void drawGL(const Frustum& view_volume) const;
      void drawGL() const;

      //! Draw only a given mesh
      /*! \param wireframe draw as a wireframe if true */
      void drawPartGL(int, bool wireframe=false, float alpha=1.0, bool use_alt=false) const;

      void invalidateListNames() const;

      static GLuint findTexture(std::string);
      static void setTexture(std::string, GLuint);

      top10::helpers::PolygonSet* polygons;

      //! One texture for each surface
      std::vector<Texture> textures;

    private:
      mutable GLuint listname;
      mutable top10::physX::Octree* octree;

      typedef std::map<std::string, GLuint> texture_names_map;
      static texture_names_map texture_names;
    };

  };
};

#endif
