/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef OPTIONS_HH
#define OPTIONS_HH

#include <string>

#include <SDL.h>

#include "ForceFeedback.hh"
#include "util/error.hh"

namespace top10 {
  namespace ui_interactive {
    namespace options {
      extern void parse(int argc, char** argv) throw(top10::util::Error);

      /// Screen size
      extern int w, h;

      /// Color depth of screen
      extern int depth;

      /// The joystick type
      extern FFDevice* ffdev;
      extern bool use_ff;

      /// Full screen should be used
      extern bool full_screen;

      /// Playback from a file
      extern bool replay_from_file;
      extern std::string replay_filename;

      /// Record to a file
      extern bool record_to_file;
      extern std::string record_filename;

      /// Play sounds
      extern bool use_audio;

      /// Use the mouse for the steering wheel
      extern bool use_mouse;

      /// Base of name of file containing tracks data 
      extern std::string track_filename;

      /// Name of file containing the description of the kart
      extern std::string kart_filename;

      /// Slow factor
      extern double slow_factor;

      /// Benchmark of the physics engine
      extern bool physx_benchmark;

	extern int w_texture_div;
	extern int h_texture_div;
    };
  };
};

#endif
