/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef MAIN_MENU_HH
#define MAIN_MENU_HH

#include "UIPanel.hh"
#include "Controls.hh"
#include "Simulation.hh"
#include "FileMenu.hh"
#include "YesNoMenu.hh"
#include "WetNotifier.hh"
#include "audio.hh"
#include <iostream>

namespace top10 {
  namespace ui_interactive {
    class MainMenu: public UIPanel::Menu {
    public:
      MainMenu(UIPanel*, bool* quit, ActionMapping* actions, Simulation** simulation_ref, AudioDevice* audio);

      //! Replay a previously recorded training session
      void replay(std::string filename);

      //! Play, and record a training session
      void play(std::string filename);

      //! Load a description of a kart
      void loadKartGL(std::string filename);

      ~MainMenu();

    private:
      void playOrReplay(std::string, std::string);

      //! Create a simulation when a track file is selected
      class TrackFileNotifier: public FileMenu::Notifier {
      public:
	TrackFileNotifier(MainMenu* menu);
	void fileSelected(std::string track_file);
      private:
	MainMenu* menu;
      };

      //! Replay a recorded session
      class ReplayFileNotifier: public FileMenu::Notifier {
      public:
	ReplayFileNotifier(MainMenu* menu);
	void fileSelected(std::string replay_file);
      private:
	MainMenu* menu;
      };

      //! Set the model of the kart to draw
      class KartNotifier: public FileMenu::Notifier {
      public:
	KartNotifier(MainMenu* menu);
	void fileSelected(std::string kart_file);
      private:
	MainMenu* menu;
      };

      TrackFileNotifier track_notifier;
      ReplayFileNotifier replay_notifier;
      KartNotifier kart_notifier;
      WetNotifier wet_notifier;
      YesNoMenu::BoolNotifier quit_notifier;

      top10::track::Track* track;
      std::istream* record_in;
      std::ostream* record_out;
      Simulation** simulation_ref;
      AudioDevice* audio_device;
      KartGL kart_gl;
    };
  };
};

#endif
