/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "FileMenu.hh"
#include "util/PathFinder.hh"
#include <plib/ul.h>

using namespace top10::ui_interactive;

void FileMenu::selected()
{
  assert(notifier);
  
  if (!entries.empty())
    notifier->fileSelected(entries[getEntryN()]);
  panel->hide();
}

static bool isOfExtension(std::string filename, std::string ext)
{
  int s = filename.size();
  int s2 = ext.size();

  if (s <= s2) return false;

  return filename.substr(s-s2, s2) == ext;
}

void FileMenu::buildFileList()
{
  std::string dirpath = top10::util::PathFinder::find(path);
  if (dirpath.empty()) throw std::string("Could not find directory: ")+path;

  ulDir* uldir = ulOpenDir(dirpath.c_str());
  if (!uldir) throw std::string("Could not open directory: ")+dirpath;

  ulDirEnt* dirent = ulReadDir(uldir);
  while (dirent) {
    if (!dirent->d_isdir) {
      std::string name = dirent->d_name;
      if (isOfExtension(name, extension)) {
	entries.push_back(name);
	links.push_back(0);
      }
    }
    dirent = ulReadDir(uldir);
  }
  ulCloseDir(uldir);
}
