/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "TrackDlg.hh"
#include "QGLView.hh"

#include <qmessagebox.h> 
#include <qfiledialog.h> 

#include <fstream>

TrackDlg::TrackDlg()
{
  main_ed.setMeshEditor(&mesh_ed);
  main_ed.setSurfacesEditor(&surf_ed);
  main_ed.setDecorationsEditor(&deco_ed);
  main_ed.setCheckpointsEditor(&cps_ed);
  main_ed.setStartingAreaEditor(&sa_ed);

  surf_ed.setMeshEditor(&mesh_ed);
  deco_ed.setMeshEditor(&mesh_ed);
  cps_ed.setMeshEditor(&mesh_ed);
  sa_ed.setMeshEditor(&mesh_ed);

  mesh_ed.setCamera(&camera);

  trackView->setMainCamera(&camera);
  trackView->addDrawable(&mesh_ed);
  trackView->addDrawable(&surf_ed);
  trackView->addDrawable(&deco_ed);
  trackView->addDrawable(&cps_ed);
  trackView->addDrawable(&sa_ed);

  mesh_dlg.setViewer(trackView);
  surf_dlg.setViewer(trackView);
  deco_dlg.setViewer(trackView);
  cps_dlg.setViewer(trackView);
  sa_dlg.setViewer(trackView);

  mesh_dlg.setEditor(&mesh_ed);
  surf_dlg.setEditor(&surf_ed);
  deco_dlg.setEditor(&deco_ed);
  cps_dlg.setEditor(&cps_ed);
  sa_dlg.setEditor(&sa_ed);

  mesh_dlg.update();
  cps_dlg.update();
  sa_dlg.update();
  surf_dlg.update();
  deco_dlg.update();
}

void TrackDlg::fileOpen()
{
  QString s = QFileDialog::getOpenFileName("./", "Tracks (*.trk)", this,
					   "open file dialog", "Choose a file");
  if (!s.isEmpty()) {
    try {
      main_ed.loadTrack(s.ascii());
      filename = s.ascii();
    }
    catch (std::string err) {
      QMessageBox::warning(this, "Error", err.c_str());
    }
    catch (...) {
      QMessageBox::warning(this, "Error", "Unknown"); 
    }

    mesh_dlg.update();
    cps_dlg.update();
    sa_dlg.update();
    surf_dlg.update();
    deco_dlg.update();
  }
}

void TrackDlg::fileSaveAs()
{
  QString s = QFileDialog::getSaveFileName("./", "Tracks (*.trk)", this,
					   "open file dialog", "Choose a file");
  if (!s.isEmpty()) {
    std::string new_filename = s.ascii();
    std::ifstream in(new_filename.c_str());
    if (in) {
      int button = QMessageBox::warning(this, "Warning", (new_filename + " will be overwritten").c_str(),
					QMessageBox::Ok, QMessageBox::Cancel | QMessageBox::Default);
      if (button == QMessageBox::Ok) {
	filename = new_filename;
	fileSave();
      }
    }
    else {
      filename = new_filename;
      fileSave();
    }
  }  
}

void TrackDlg::fileSave()
{
  if (!filename.empty()) {
    try {
      main_ed.saveTrack(filename);
    }
    catch (std::string err) {
      QMessageBox::warning(this, "Error", err.c_str());
    }
    catch (...) {
      QMessageBox::warning(this, "Error", "Unknown"); 
    }
  }
  else QMessageBox::question(this, "Uh", "Save the Queen", QMessageBox::Yes, QMessageBox::No);
}

void TrackDlg::toggleCheckpointsDlg(bool b)
{
  if (b) {
    cps_dlg.show();
    cps_ed.setVisible(true);
  }
  else {
    cps_dlg.hide();
    cps_ed.setVisible(false);
  }
  trackView->updateGL();
}

void TrackDlg::toggleStartingAreaDlg(bool b)
{
  if (b) {
    sa_dlg.show();
    sa_ed.setVisible(true);
  }
  else {
    sa_dlg.hide();
    sa_ed.setVisible(false);
  }
  trackView->updateGL();
}

void TrackDlg::toggleMesh(bool b)
{
  if (b) {
    mesh_dlg.show();
    mesh_ed.setVisible(true);
  }
  else {
    mesh_dlg.hide();
    mesh_ed.setVisible(false);
  }
  trackView->updateGL();
}

void TrackDlg::toggleDecorations(bool b)
{
  if (b) {
    deco_dlg.show();
    deco_ed.setVisible(true);
  }
  else {
    deco_dlg.hide();
    deco_ed.setVisible(false);
  }
  trackView->updateGL();
}

void TrackDlg::toggleSurfaces(bool b)
{
  if (b) {
    surf_dlg.show();
    surf_ed.setVisible(true);
  }
  else {
    surf_dlg.hide();
    surf_ed.setVisible(false);
  }
  trackView->updateGL();
}
