/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "SurfacesDlg.hh"
#include <cassert>
#include <qstring.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qmessagebox.h>

using top10::tracked::SurfaceTypeEnum;
using top10::tracked::Road;
using top10::tracked::DustyRoad;
using top10::tracked::Border;
using top10::tracked::Grass;
using top10::tracked::Dirt;
using top10::tracked::Sand;

SurfacesDlg::SurfacesDlg(): surf_ed(0), viewer(0)
{
}

void SurfacesDlg::pickSurface()
{
  assert(surf_ed);
  assert(viewer);

  surf_ed->pick();
  if (!surf_ed->getCurrentSurface().empty())
    surf_ed->add();

  viewer->updateGL();
  update();
}

void SurfacesDlg::populateSurfaceList(int idx)
{
  assert(surf_ed);
  assert(viewer);

  switch(idx) {
  case 0: surf_ed->setCurrentSurfaceType(Road); break;
  case 1: surf_ed->setCurrentSurfaceType(DustyRoad); break;
  case 2: surf_ed->setCurrentSurfaceType(Border); break;
  case 3: surf_ed->setCurrentSurfaceType(Grass); break;
  case 4: surf_ed->setCurrentSurfaceType(Sand); break;
  case 5: surf_ed->setCurrentSurfaceType(Dirt); break;
  default: assert(0); break;
  }

  update();
}

void SurfacesDlg::update()
{
  assert(surf_ed);
  assert(viewer);

  SurfaceTypeEnum surf_type = surf_ed->getCurrentSurfaceType();
  physicsCombo->setCurrentItem((int)surf_type);

  surfaceList->clear();
  std::set<std::string> strs = surf_ed->getCurrentSurfaceSet();
  for (std::set<std::string>::const_iterator it = strs.begin();
       it != strs.end();
       ++it) {
    surfaceList->insertItem(QString(it->c_str()));
  }
}
