/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_QGLVIEW_HH
#define TOP10_QGLVIEW_HH

#include <qgl.h>
#include "trackedit/Drawable.hh"
#include "trackedit/MainCamera.hh"

class QGLView: public QGLWidget
{
public:
  QGLView(QWidget*, const char*);
  inline void setMainCamera(top10::tracked::MainCamera* c) { camera = c; }
  inline void addDrawable(top10::tracked::Drawable* d) { drawables.push_back(d); }

protected:
  void initializeGL();
  void resizeGL(int w, int h);
  void paintGL();

  void mouseMoveEvent(QMouseEvent*);
  //  void mousePressEvent(QMouseEvent*);
  //  void keyPressEvent(QKeyEvent*);

private:
  //! Used to keep track of mouse movements
  int old_x, old_y;

  top10::tracked::MainCamera* camera;
  std::vector<top10::tracked::Drawable*> drawables;
};

#endif
