/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "MeshDlg.hh"
#include <qstring.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>

MeshDlg::MeshDlg(): mesh_ed(0), viewer(0)
{
}

void MeshDlg::selectFile()
{
  QString s = QFileDialog::getOpenFileName("./", "Mesh (*.3ds *.lw)", this,
					   "open file dialog", "Choose a file");
  if (!s.isEmpty()) {
    MeshFilenameEdit->setText(s);
    setMeshFilename();
  }
}

void MeshDlg::setMeshFilename()
{
  assert(mesh_ed);
  assert(viewer);

  try {
    mesh_ed->loadMesh(MeshFilenameEdit->text().ascii());
  }
  catch (std::string err) {
    QMessageBox::warning(this, "Error", err.c_str());
  }
  catch (...) {
    QMessageBox::warning(this, "Error", "Unknown"); 
  }
  update();
  viewer->updateGL();
}

void MeshDlg::setNegative(int n)
{
  assert(mesh_ed);
  assert(viewer);
  mesh_ed->axis_negate = n!=0;
  viewer->updateGL();
}

void MeshDlg::setAxis(int n)
{
  assert(viewer);
  assert(mesh_ed);
  switch(n) {
  case 0: mesh_ed->axis = top10::math::X; break;
  case 1: mesh_ed->axis = top10::math::Y; break;
  case 2: mesh_ed->axis = top10::math::Z; break;
  default: assert(0);
  }
  viewer->updateGL();
}

void MeshDlg::setScale(const QString& s)
{
  assert(mesh_ed);
  assert(viewer);
  mesh_ed->scaling = s.toFloat();
  viewer->updateGL();
}

void MeshDlg::update()
{
  assert(mesh_ed);
  MeshFilenameEdit->setText(QString(mesh_ed->model_filename.c_str()));
  AxisComboBox->setCurrentItem((int)mesh_ed->axis);
  NegativeCheckBox->setChecked(mesh_ed->axis_negate);
  QString tmp;
  tmp.setNum(mesh_ed->scaling);
  ScaleEdit->setText(tmp);
}
