/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "CheckpointsDlg.hh"
#include <qstring.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>

CheckpointsDlg::CheckpointsDlg():
  cps_ed(0), viewer(0)
{
}

void CheckpointsDlg::nextCheckpoint()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->next();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::prevCheckpoint()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->previous();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::delCheckpoint()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->remove();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::insertCheckpoint()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->addNew();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::pickCheckpoint1()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->pickLeft();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::pickCheckpoint2()
{
  assert(cps_ed);
  assert(viewer);
  cps_ed->pickRight();
  viewer->updateGL();
  update();
}

void CheckpointsDlg::update()
{
  assert(cps_ed);
  top10::racing::CheckPoint cp = cps_ed->getCurrent();
  QString tmp;
  tmp.setNum(cp.getPoint1().x);
  XEditCP1->setText(tmp);
  tmp.setNum(cp.getPoint1().z);
  ZEditCP1->setText(tmp);
  tmp.setNum(cp.getPoint2().x);
  XEditCP2->setText(tmp);
  tmp.setNum(cp.getPoint2().z);
  ZEditCP2->setText(tmp);
  
  MaxNum->display((int)cps_ed->checkpoints.size());
  int idx = cps_ed->getCurrentIndex();
  if (idx == -1) {
    CurrNum->display(88);
    PickBtn->setEnabled(false);
    PickBtn_2->setEnabled(false);
    PrevBtn->setEnabled(false);
    XEditCP1->setEnabled(false);
    ZEditCP1->setEnabled(false);
    XEditCP2->setEnabled(false);
    ZEditCP2->setEnabled(false);
    DelBtn->setEnabled(false);
  }
  else {
    CurrNum->display(idx);
    PickBtn->setEnabled(true);
    PickBtn_2->setEnabled(true);
    PrevBtn->setEnabled(true);
    XEditCP1->setEnabled(true);
    ZEditCP1->setEnabled(true);
    XEditCP2->setEnabled(true);
    ZEditCP2->setEnabled(true);
    DelBtn->setEnabled(true);
  }

  // is the current checkpoint the last one?
  if (idx+1 == (int)cps_ed->checkpoints.size()) {
    NextBtn->setEnabled(false);
  }
  else {
    NextBtn->setEnabled(true);
  }
}
