/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_PLIB_CAMERA_HH
#define TOP10_PLIB_CAMERA_HH

#include "../MainCamera.hh"
#include <SDL.h>

class Camera: public top10::tracked::MainCamera
{
public:
  Camera(): width(800), height(600), old_x(-1), old_y(-1) {}

  inline void setScreenSize(unsigned int w, unsigned int h) { width=w; height=h; }
  void handleEvent(SDL_Event);

private:
  unsigned int width;
  unsigned int height;

  //! Used to keep track of mouse movements
  int old_x, old_y;
};

#endif
