/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "DecorationsEditor.hh"

using namespace top10::tracked;

DecorationsEditor::DecorationsEditor(): mesh_ed(0)
{
  reset();
}

void DecorationsEditor::reset()
{
  current_mesh.clear();
}

void DecorationsEditor::pick()
{
  assert(mesh_ed);

  current_mesh = mesh_ed->getPickedMesh();
}

void DecorationsEditor::add()
{
  if (current_mesh.empty()) throw std::string("Select a mesh to add first");
  decorations.insert(current_mesh);
}

void DecorationsEditor::remove()
{
  if (current_mesh.empty()) throw std::string("Select a mesh to remove first");
  std::set<std::string>::const_iterator f = decorations.find(current_mesh);
  if (f == decorations.end()) throw std::string("Cannot remove mesh: ")+current_mesh;
  decorations.erase(f);
}

void DecorationsEditor::drawGL_impl() const
{
  assert(mesh_ed);
  top10::ui_interactive::TriangleSet* gl_polys = mesh_ed->getGLPolys();
  if (!gl_polys) return;

  top10::helpers::PolygonSet* polys = mesh_ed->getPolys();
  assert(polys);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  mesh_ed->setTransformGL();

  // Draw all the meshes that are decorations
  for (int i=(int)polys->meshes.size()-1; i>=0; --i) {
    if (decorations.find(polys->meshes[i].name) != decorations.end()) {
      gl_polys->drawPartGL(i, true);
    }
  }

  glPopMatrix();
}
