/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_WORLD_H
#define TOP10_WORLD_H

#include <vector>

#include "util/Dumpable.hh"
#include "Point.hh"
#include "ComplexObject.hh"
#include "Octree.hh"

namespace top10 {
  namespace physX {

    class World: public top10::util::Dumpable
    {
    public:
      const static unsigned int time_slice;
      const static double G;

      inline void setOctree(const Octree& octree) { collision_octree = octree; }
      inline const Octree* getOctree() const { return &collision_octree; }

    public:
      std::vector<ComplexObject*> objects;

      void simulate();

      void dumpTo(std::ostream&) const;
      void loadFrom(std::istream&);

    private:
      //! To accelerate soft-collisions
      Octree collision_octree;
    };
  };
};

#endif
