/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "World.hh"

using namespace top10::physX;
using namespace std;
const double World::G=9.81;
const unsigned int World::time_slice=5;

void World::simulate()
{
  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    (*p)->collideTrack(time_slice/1000.0);
  }

  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    Octree::ShapeRefs colliding = collision_octree.getVolume((*p)->getBoundingBox());
    if (!colliding.empty())
      (*p)->collideObjects(collision_octree.getShapeVec(), colliding, time_slice/1000.0);
  }

  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    (*p)->update(G, time_slice/1000.0);
  }

  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    (*p)->integrate(time_slice/1000.0);
  }
}

void World::dumpTo(std::ostream& str) const
{
  //! \todo implementation
}

void World::loadFrom(std::istream& str)
{
  //! \todo implementation
}

#include "helpers/GenericOctree-template.cpp"
