/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Octree.hh"

using namespace top10::physX;
using top10::helpers::PolygonSet;
using top10::helpers::Mesh;

#define OCTREE_BASE top10::helpers::GenericOctree<top10::helpers::Polygon>

//! Function used when building a GenericOctree<ShapeT>
void top10::helpers::GenericOctree__getBoundingBox(const top10::helpers::Polygon& shape,
						   double& minX, double& maxX,
						   double& minY, double& maxY,
						   double& minZ, double& maxZ) {
  for (int i=shape.p.size()-1; i>=0; --i) {
#define MIN(a,b) ((a)<(b))?(a):(b)
#define MAX(a,b) ((a)>(b))?(a):(b)
    minX=MIN(minX, shape.p[i].x);
    minY=MIN(minY, shape.p[i].y);
    minZ=MIN(minZ, shape.p[i].z);
    maxX=MAX(maxX, shape.p[i].x);
    maxY=MAX(maxY, shape.p[i].y);
    maxZ=MAX(maxZ, shape.p[i].z);
#undef MIN
#undef MAX
  }
}

Octree::Octree(const PolygonSet* polyset, std::set<std::string> colliding_mesh_names)
{
  // For each mesh
  for (std::vector<Mesh>::const_iterator mesh = polyset->meshes.begin();
       mesh != polyset->meshes.end();
       ++mesh) {
    // If it is a mesh with collision enabled
    if (colliding_mesh_names.find(mesh->name) != colliding_mesh_names.end()) {
      // For each polygon in the mesh
      for (int poly_idx = mesh->begin; poly_idx != mesh->end; ++poly_idx) {
	poly_vec.push_back(polyset->at(poly_idx));
      }
    }
  }

  OCTREE_BASE::operator=(OCTREE_BASE(poly_vec));
}

Octree::Octree(const PolygonSet* polyset)
{
  // For each mesh
  for (std::vector<Mesh>::const_iterator mesh = polyset->meshes.begin();
       mesh != polyset->meshes.end();
       ++mesh) {
    // For each polygon in the mesh
    for (int poly_idx = mesh->begin; poly_idx != mesh->end; ++poly_idx) {
      poly_vec.push_back(polyset->at(poly_idx));
    }
  }

  OCTREE_BASE::operator=(OCTREE_BASE(poly_vec));
}

#include "helpers/GenericOctree-template.cpp"
