/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Matrix.hh"
#include <cstdlib>
#include <iostream>

#define EPSILON 1e-10

int main(int argc, char** argv)
{
  using namespace top10::math;

  // Inversion test
  for (int t=0; t<10; ++t) {
    double vals[3][3];
    for (int i=0; i<3; ++i) {
      for (int j=0; j<3; ++j) {
	vals[i][j] = (rand()%10000)/3000.0;
      }
    }
    Matrix3 M(vals);
    if (M.det() != 0.0) {
      Matrix3 N = inverse(M);
      Matrix3 P = M*N;

      for (int i=0; i<3; ++i) {
	for (int j=0; j<3; ++j) {
	  if (i==j) { if (fabs(P(i,j)-1.0) > EPSILON) std::cout<<"1 != "<<P(i,j)<<std::endl; }
	  else { if (fabs(P(i,j)) > EPSILON) std::cout<<"0 != "<<P(i,j)<<std::endl; }
	}
      }
    }
    std::cout<<"--------------"<<std::endl;
  }
}
