#ifndef TOP10_MATH_TRIANGLE_HH
#define TOP10_MATH_TRIANGLE_HH

#include "Vertex.hh"
#include "Matrix.hh"

namespace top10 {
  namespace math {
    struct Triangle
    {
      Vector p[3];

      //! Uninitialized triangle.
      Triangle() {};

      Triangle(Vector p0, Vector p1, Vector p2) {
	p[0] = p0;
	p[1] = p1;
	p[2] = p2;
      }

      void translate(Vector);
      void rotate(const Matrix3&);

      //! Check for intersection with a ray
      bool intersectRay(Vector origin, Vector direction, Vector& I, double& d) const;
    };
  };
};
#endif
