/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_CURVE_H
#define TOP10_CURVE_H

#include <map>
#include <valarray>
#include "util/Dumpable.hh"

namespace top10 {
  namespace math {
    /**
       Function from doubles to doubles.
       Controlled by control points with straight lines in between
    */
    class Curve2D: public top10::util::Dumpable
    {
    public:
      Curve2D() {};

      /**
	 Compute the Y value corresponding to x
      */
      double getY(double x) const;

      /**
	 Insert a control point
	 \return false if another point with same x allready exists
      */
      bool addXY(double x, double y);

      /**
	 Remove a control point.
	 \return true if control point could be removed
      */
      bool removeXY(double x);

      inline Curve2D& operator=(const Curve2D& other)
      {
  	ctrl_points = other.ctrl_points;
  	return *this;
      }

      void dumpTo(std::ostream&) const;
      void loadFrom(std::istream&);

    private:
      std::map<double, double> ctrl_points;
    };

    typedef std::valarray<double> PointND;

    /**
       Function from doubles to array of doubles
    */
    class CurveND: public std::map<double, PointND >
    {
    public:
      CurveND() {};

      PointND get(double t) const;

      bool add(double t, const PointND& v);
    };

  };
};
#endif
