<?php
function showFormUserPrefs(&$render,$user) {
	require_once("render/form_elements.php");
	require_once("render/html.php");

	h2($render,_('User preferences'));
	showFormElementStart($render);
	showFormElementHidden($render,'UserID',$user['UserID']);
	showFormElementUserName($render,$user['Name']);
	showFormElementUserEmail($render,$user['Email']);
	showFormElementPassword($render,
		_("New password"),"Password",
		$user['Password']);
	showFormElementPassword($render,
		_("New password (again)"),"ConfirmPassword",
		$user['Password']);

	showFormBooleanField($render,
		"NotifyComment",
		_("Send me a mail when a comment is added on one of my pictures"),
		$user['NotifyComment']);

	showDiskUsage($render,$render->user);
	$render->show('<br>');

	showFormElementAction($render,"updatePrefs");
	showFormElementEnd($render,_("Update preferences"));
}

function renderUser(&$render,$userID) {
	require_once("render/form_elements.php");
	require_once("render/navbar.php");

	$render->setView(array('UserID'=>$userID));
	if ($userID) {
		$user = $render->ct->getUser($userID);
		if (is_array($user)) {
			$count = count($render->ct->getPicturesOwnedBy($userID));
			$render->setBareTitle(
				sprintf(_('User #%s:'),$userID).
				' '.$user['Name'].' ('.sprintf(_('%s pictures'),$count).')');
			$render->show('<div class="normal">');
			if ($render->isAdmin) {
				showFormElementStart($render);
				showFormElementHidden($render,'UserID',$userID);
			}
			$render->show(_('Name:').' '.$user['Name'].'<br>');
			$render->show(_('Login name:').' '.$user['Username'].'<br>');
			$render->show(_('Email:').' '.$user['Email'].'<br>');
			if ($render->isAdmin) {
				showFormBooleanField($render,'AllowUpload',_('Can upload pictures'),$user['Upload']);
			} else {
				$render->show(_('Can upload pictures:').' ',false);
				$render->show($render->formatYesNo($user['Upload']).'<br>');
			}

			if ($render->isAdmin) {
				showFormBooleanField($render,
					'IsAdmin',_('Administrator'),$user['Admin']);
			} else {
				$render->show(_('Administrator:').' ',false);
				$render->show($render->formatYesNo($user['Admin']).'<br>');
			}

			if ($render->isAdmin) {
				showFormBooleanField($render,
					'AllowSelect',_('Can select pictures'),$user['Selection']);
			} else {
				$render->show(_('Can select pictures:').' ',false);
				$render->show($render->formatYesNo($user['Selection']).'<br>');
			}

			showDiskUsage($render,$user);
			$render->show('<br>');

			if ($render->isAdmin || $render->uid == $UserID) {
				$render->show(_('Disk quota: '));
				showFormElementSize($render,'Quota',$user['Quota']);
				$render->show('<br>');
			}
			if ($render->isAdmin) {
				showFormElementAction($render,'updateUser');
				showFormElementEnd($render,_('Update'));
			}


			if ($render->isAdmin) {
				$render->show('<h2>'._('Act as this user').'</h2>');
				showFormElementStart($render);
				showFormElementHidden($render,'Owner',$userID);
				showFormElementAction($render,'changeUser');
				showFormElementEnd($render,_('Change user'));	  

				$render->show('<h2>'._('Remove user').'</h2>');
				showFormElementStart2($render,$render->actionAndViewURL("Users=t"));
				showFormElementHidden($render,'UserID',$userID);
				showFormBooleanField($render,'RemovePictures',_('Remove pictures'),false);
				showFormBooleanField($render,'DeleteFiles',_('Delete files'),false);
				showFormElementAction($render,'deleteUser');
				showFormElementEnd($render,_('Remove user'));
			}
			$render->show('</div>');
		} else {
			$render->error(
				sprintf(_('No such user with ID = %s'),$userID));
		}
	} else {
		$render->error(_("No user ID provided"));
	}
	showNavBar($render);
}

function showFormElementUserName(&$render,$value="") {
	$render->show(
		_('Name:').
		' <input type="text" size="32" name="Name" value="'.$value.'"><br>');
}
  
function showFormElementUserEmail(&$render,$value="") {
	$render->show(
		_('Email:').
		' <input type="text" size="32" name="Email" value="'.$value.'"><br>');
}

/* private show password entry input */
function showFormElementPassword(&$render,$text,$name,$value="") {
	$render->show("$text : <input type=\"password\" name=\"$name\" value=\"$value\"><br>");
}

function showDiskUsage(&$render,$user) {
	if (isset($user['Quota']) && $user['Quota']!=='')
		$quota = makeSizeString($user['Quota']);
	else
		$quota = _('unlimited');
	$render->show(
		sprintf(_('Disk usage: %s of %s'),
				makeSizeString($user['DiskUsage']),
				$quota));
	$render->show('<button name="action2" value="updateDiskUsage">'.
				_('Update disk usage').'</button>');
}
?>