<?php
function renderPictureInRoll(&$render, $pictureID, $rollID, $position) {
	require_once("render/picture.php");
	$render->setSelection(array('RollID'=>$rollID));
	$render->setView(array('RollID'=>$rollID,
						 'PictureID'=>$pictureID,
						 'Position'=>$position));
	if ($pictures = $render->ct->getPictureInRoll($pictureID, $rollID, $position, $render->uid)) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	}
}

/* Render a page body for a given roll */
function renderRoll(&$render, $rollID, $start) {
	require_once("render/header.php");
	require_once("render/thumb.php");
	require_once("render/form_roll.php");
	require_once("render/navbar.php");

	$render->setSelection(array('RollID'=>$rollID));
	$render->setView(array('RollID'=>$rollID,
						 'Start'=>$start));
	if (!$render->ct->getRoll($rollID)) {
		$render->error(_("Roll not found : ").$rollID);
		showNavBar($render);
	} else {
		list($count,$pictures) = 
			$render->ct->getPicturesInRoll(
				$rollID,$render->uid,'pictures.*');
		$render->setTitle(_("Roll")." ".$rollID.countString($render,$start,$count));
		$render->show('<div class="normal">');
		showThumbs(
			$render,
			array_slice($pictures,$start,$render->nbThumbsPerPage),
			$start,$count,'','','FrameID');
		if ($render->admin) {
			if (count($pictures)>0) {
				showFormAddKeywords($render,$rollID,$pictures);
				showFormUpdatePictures($render,$rollID,$pictures);
				$render->show('<hr class="transpa">');
			}
			showFormAddAllPictures($render,$rollID);
			showFormAddPicture($render,$rollID);
			$render->show('<hr class="transpa">');
			showFormDeleteRoll($render,$rollID);
		}
		$render->show('</div>');
	}
}
?>