<?php
function showNavs(&$render,$topics) {
	$render->show('<div id="topicsnav">');
	foreach($topics as $topic) {
		showNav($render,$topic['TopicID']);
	}
	$render->show('</div>');
}

/** show a hyperlinked topic heirarchy down to the given topic */
function showNav(&$render,$topicID = 0, $id = '') {
	if ($topic = $render->ct->getTopic($topicID)) {
		  if ($topicID == 0) {
			  $render->show('<p class="path"'.($id?" id=\"$id\"":'').'><a href="'.$render->selfURL().'">'.
						  $topic['Description'].'</a>');
		  } else {
			  showNav($render,$topic['ParentTopicID'],$id);
			  $render->show(' : <a href="' . $render->selfURL(
				  "TopicID=" . rawurlencode($topic['TopicID'])) .
						  '">' . $topic['Description'].'</a>');
		  }
	}
}
?>