<?php
function getPicturePos(&$tof,&$picture)
{
	getPictureSize($tof,$picture,$imageWidth,$imageHeight);
	return getImagePos(	
		$imageWidth,$imageHeight,
		$picture['Box']['left'],$picture['Box']['bottom'],
		$picture['Box']['width'],$picture['Box']['height'],
		$picture['halign'],$picture['valign']);
}

function getImagePos(
	$imageWidth,$imageHeight,
	$x,$y,$width,$height,
	$halign=CENTER,$valign=CENTER)
{
	$boxRatio = $width / $height;
	$ratio = $imageWidth / $imageHeight;
	$xoffset = $x;
	$yoffset = $y;
	if ($ratio<$boxRatio) {
		$scale = $height/$imageHeight;
		$xoffset += ($width - ($imageWidth * $scale)) * $halign;
	} else {
		$scale = $width/$imageWidth;
		$yoffset += ($height - ($imageHeight * $scale)) * $valign;
	}

	$pos = array('x'=>$xoffset,
				 'y'=>$yoffset,
				 'width'=>$imageWidth*$scale,
				 'height'=>$imageHeight*$scale,
				 'scale'=>$scale);
	$pos['top'] = $pos['y'] + $pos['height'];
	$pos['right'] = $pos['x'] + $pos['width'];
	$pos['bottom'] = $pos['y'];
	$pos['left'] = $pos['x'];
	return $pos;
}

function getPictureSize(&$tof,$picture,&$width,&$height) {
	$filename = $tof->getOrigFilename($picture);
	if (file_exists($filename)) {
		$size = GetImageSize($filename);
	} else {
		$filename = $tof->getPictureFilename($picture);
		if (file_exists($filename)) {
			$size = GetImageSize($filename);
		} else {
			$filename = $tof->getThumbFilename($picture);
			if (file_exists($filename)) {
				$size = GetImageSize($filename);
			}
		}
	}
	if ($size) {
		$width = $size[0];
		$height = $size[1];
	}
}

?>