<?php
/**
 * Show the keywords of a picture
 */
function showKeywords(&$render,$pictureID) {
	$render->show("<h2>"._("Keywords")."</h2>");
	$render->show('<ul id="keywords'.$pictureID.'">');
	$keywords = $render->ct->getTypedKeywords($pictureID);
	$count = 0;
	foreach($keywords as $keyword) {
		$id = 'k'.$count++;
		showKeywordItem($render,$pictureID,$keyword,$id);
	}
	$keywords = $render->ct->getUntypedKeywords($pictureID);
	foreach($keywords as $keyword) {
		$id = 'k'.$count++;
		showKeywordItem($render,$pictureID,$keyword,$id);
	}
	$render->show("</ul>");
}


function showKeywordItem(&$render,$pictureID,$keyword,$id) {
	require_once("render/actions.php");
	$render->show(
		"<li id=\"$id\">" . 
		($keyword['Type']!=0 ? $keyword['Libelle_fr'] . " = " : "").
		"<a href=\"".$render->selfURL(
			"TypeID=".$keyword['Type'].$render->output_separator.
			"Keyword=".rawurlencode($keyword['Value']))."\">" .
		$keyword['Value'] . "</a>");
	if ($render->admin)
		showIconRPC(
			$render,
			"delete.png",
			_('remove'),
			"removeKeyword",
			array('PictureID' => $pictureID,
				  'TypeID' => $keyword['Type'],
				  'KeywordValue' => $keyword['Value'],
				  '_RemoveID' => $id));
}
?>