<?php
function showFormElementTopics(&$render,$topics,$name="TopicID") 
{
	$render->show(_('Topic: '));
	$render->show("<select name=\"$name\">");
	foreach($topics as $topic) {
		$render->show(
			"<option value=\"" . $topic['TopicID'] . "\"" . 
			">" . $topic['Description'] . '</option>');
	}
	$render->show('</select><br>');
}

/* private: show ParentTopicID form element */
function showFormElementTopicTree(
	&$render,
	$label,
	$topics,
	$id = "") 
{
	if ($id!="")
		$id = " id=\"$id\"";
	$render->show($label."<br>");

	$render->show('<div class="topicTreeSelector">');
	showTopicsTree(
		$render,
		$render->ct->getKey('topics',0),
		'ParentTopicID[]',
		$topics);
	$render->show('</div>');
	$render->show('<br>');
}

function showTopicsTree(&$render,$topic,$name,$topics) 
{
	$topicID = $topic['TopicID'];
	$subTopics = $render->ct->getSubTopics($topicID);
	$hasSub = count($subTopics)>0;
	if ($topic['Book'])
		$render->show('<img src="book.png" alt="">',false);
	else
		$render->show(
			"<img src=\"closed_folder.png\" id=\"F$topicID\"".
			($hasSub?' onclick="toggleTree('.$topicID.')"':'').">");
	$render->show("<label class=\"cb\"><input id=\"B$topicID\" type=\"checkbox\"".
				  " name=\"$name\" value=\"$topicID\"".(in_array($topicID,$topics)?" checked":"").">".
				  '<span '.($hasSub?'class="subs" ':'').'>'.
				  $topic['Description'].
				  '</span></label>');
	if ($hasSub) {
		$render->show('<ul id="T'.$topicID.'">');
		foreach($subTopics as $subTopic) {
			$render->show('<li>',false);			  
			showTopicsTree($render,$subTopic,$name,$topics);
			$render->show('</li>');			  
		}
		$render->show('</ul>');
	}
}

/** show a form to update a topic */
function showFormUpdateTopic(&$render,$topic) {
	require_once("render/form_elements.php");
	require_once("render/form_topicid.php");
	$render->show('<h2>'._('Update album').'</h2>');
	$topicID = $topic['TopicID'];
	showFormElementStart($render);
	showFormElementTopicID($render,$topicID);
	if ($topicID != 0) { /* root topic has no parent */
		showFormElementParentTopicID($render,$topic['ParentTopicID'],false,$topicID);
	}
	showFormElementDescriptionOneLine($render,$topic['Description']);
	showFormElementSummary($render,$topic['Summary']);
	showFormElementAction($render,'updateTopic');
	showFormElementEnd($render,_('Update'));
}

function showFormUpdateTopicPerms(&$render,$topic) {
	$render->show("<h2>"._("Update album permissions")."</h2>");
	$topicID = $topic['TopicID'];
	$perms = array(WRITE,READ,OWNER,DELETE);
	foreach($perms as $perm) {
		$render->show('<div class="perms">');
		$render->show('<p><em>'.$render->permNames[$perm].'</em></p>');
		$groups = $render->ct->getTopicGroups($topicID,$perm);
		if (count($groups)>0) {
			$render->show('<ul>');
			foreach($groups as $group) {
				$id = $perm.$group['GroupID'];
				$render->show("<li id=\"$id\">".$group['Name'],false);
				showIconRPC(
					$render,
					'delete.png',
					_('remove'),
					'removeTopicPerm',
					array('_TopicID' => $topic['TopicID'],
						  '_GroupID' => $group['GroupID'],
						  '_Perm' => $perm,
						  '_RemoveID' => $id));
				$render->show("</li>");
			}
			$render->show('</ul>');
		}
		$render->show('</div>');
	}

	showFormTopicPerms($render,$topicID);
}

function showFormTopicPerms(&$render,$topicID) {
	require_once("render/form_group.php");
	$render->show('<div class="topicPerms">');
	showFormElementStart($render);
	showFormElementHidden($render,'_TopicID',$topicID);
	showFormElementGroupSelector($render);
	showFormElementPerm($render);
	$render->show('<br>');
	showFormElementAction($render,"addTopicPerms");
	showFormElementEnd($render,_("Add"));
	$render->show('</div>');
}

/** show a form to delete a topic */
function showFormDeleteTopic(&$render,$topicID) {
	require_once("render/form_elements.php");
	if ($render->ct->getTopic($topicID)) {
		$render->show("<h2>"._("Delete album")."</h2>");
		showFormElementStart($render);
		showFormBooleanField(
			$render,
			'ForceDelete',
			_('Remove all the pictures in the album'),
			false,
			_('Checking this option will not destroy the pictures. They will still exist in other albums and in the roll the belong to.'));
		showFormElementTopicID($render,$topicID);
		showFormElementAction($render,"deleteTopic");
		showFormElementEnd($render,_("Delete"));
	}
}

/** show a form to add a topic */
function showFormAddTopic(&$render,$selfURL=true,$parentTopicID=0) {
	require_once("render/form_elements.php");
	require_once("render/form_group.php");
	showFormElementStart($render,$selfURL,"post","","addTopicForm");
	showFormElementParentTopicID($render,$parentTopicID,false,"","parentTopicID",false,array(OWNER,WRITE));
	showFormElementDescriptionOneLine($render,"","topicDesc");
	showFormBooleanField(
		$render,
		'Book',_('book'),false,_('Books allow you to create custom PDF files'));
	global $papers;
	reset($papers);
	$sizes = array();
	while(list($paper,$unused) = each($papers)) {
		$sizes[$paper] = $paper;
	}
	$render->show(_('format: '));
	showFormElementSelect($render,'PaperSize',$sizes,'a4');
	showFormElementSelect(
		$render,'Orientation',
		array('portait'=>_('portait'),
			  'landscape'=>_('landscape')),
		'portait');
	$render->show('<br>');
	showFormElementSummary($render);

	$render->show('<fieldset><legend>'._('Permissions').'</legend>');
	$render->show('<div class="topicPerms">');
	showFormElementGroupSelector($render,array(EVERYBODY=>1));
	showFormElementPerm($render,array(READ,WRITE));
	$render->show('</div>');
	$render->show('</fieldset>');

	showFormElementAction($render,"addTopic");
	showFormElementEnd($render,_("Add"));
}

/* private: updates all pictures in a topic */
function showFormUpdateAllPicturesInTopic(&$render,$topicID) {
	require_once("render/form_elements.php");
	$render->show('<h2>'._('Update group for all pictures in this album').'</h2>');
	showFormElementStart($render);
	showFormElementTopicID($render,$topicID);
	showFormElementGroupSelector($render);
	showFormElementAction($render,'updateAllPicturesInTopic');
	showFormElementEnd($render,_('Update'));
}

/* private: show Description form element as text input*/
function showFormElementDescriptionOneLine(
	&$render, 
	$description = '', 
	$id = '', 
	$name = 'Description') 
{
	if ($id!='')
		$id = " id=\"$id\"";
	$render->show(_('Description:').'<br>');
	$render->show(
		"<input type=\"text\" size=\"48\" name=\"$name\" value=\"".
		$description . "\"$id><br>");
}

/* private: show Summary form element */
function showFormElementSummary(&$render,$Summary = ''){
	$render->show(_('Summary:').'<br>');
	$render->show('<textarea rows="4" cols="40" name="Summary">' .
				  $Summary . '</textarea><br>');
}

function showFormElementPerm(&$render,$checkedPerms=array()) {
	require_once("render/form_elements.php");
	foreach($render->permNames as $perm => $permName) {
		showFormElementCheckBox($render,'_Perms[]',in_array($perm,$checkedPerms),$permName,$perm);
	}
}


function showUploadTopic(&$render, $topic) {
	require_once("render/actions.php");
	
	$url = $render->actionURL(
		array('form'=>'upload',
			  'TopicID'=>$topic['TopicID']));

	$render->show(
		"<h2><a href=\"${url}\">"._('Upload pictures').'</a></h2>');
}

function showAddTopic(&$render, $topic) {
	require_once("render/actions.php");
	
	$url = $render->actionURL(
		array('form'=>'addTopic',
			  'ParentTopicID'=>$topic['TopicID']));

	$render->show(
		"<h2><a href=\"${url}\">"._('Add an album').'</a></h2>');
}

function showAddSelectionToTopic(&$render, $topic) {
	$render->show('<h2>'._('Add selection to topic').'</h2>');
	showFormElementStart($render);
	showFormElementHidden($render,'ParentTopicID',$topic['TopicID']);
	showFormElementAction($render,"addSelectionToTopic");
	showFormElementEnd($render,_("Add selection"));
}
?>