<?php // -*- mode: php -*-
class Query {
	var $table = '';
	var $columns = array();
	var $order = array();
	var $joins = array(); // table -> ( column | [leftColumn, rightColumn] )
	var $filters = array();
	var $distincts = array();
	var $groups = array();
	var $into = false;
	var $hasLimit = false;
	var $offset = 0;
	var $limit;

	function Query($table,$columns='*',$filters=array(),$order=array()) {
		$this->table = $table;
		if ($filters=='') 
			$filters = array();
		if ($order=='') 
			$order = array();
		$this->columns = is_array($columns) ? $columns : array($columns);
		$this->filters = is_array($filters) ? $filters : array($filters);
		$this->order = is_array($order) ? $order : array($order);
	}

	function addOrder($column) {
		if (array_search($column,$this->order)===false)
			$this->order[] = $column;
	}

	function addJoin($table, $column) {
		$this->joins[$table] = $column;
	}

	function addFilter($filter) {
		$this->filters[] = $filter;
	}

	function addDistinct($column) {
		$this->distincts[] = $column;
	}

	function addGroup($column) {
		$this->groups[] = $column;
	}

	function setInto($into) {
		$this->into = $into;
	}

	function setLimit($offset,$limit) {
		$this->hasLimit = true;
		$this->offset = $offset;
		$this->limit = $limit;
	}
}
?>