/*
  Copyright (C) 2004 Laurent Martelli <laurent@aopsys.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.Type1Font.Metrics;
import com.lowagie.text.pdf.Type1Font;
import java.util.Iterator;
import java.util.Map.Entry;
import java.io.File;

/**
 * Utility to create .kern files containing kerning information.
 *
 * Usage: java FontKern <font_file>
 */
public class FontKern {
    public static void main(String args[]) throws Exception {
        String filename = args[0];

        Type1Font font = new Type1Font(filename,BaseFont.WINANSI,false,null,null);
        System.out.println("<?php\n$this->kern['"+font.getPostscriptFontName()+"'] = array(");
        Iterator it = font.getKernPairs().entrySet().iterator();
        while(it.hasNext()) {
            Entry entry = (Entry)it.next();
            String first = (String)entry.getKey();
            int firstCode = nameToWinansi(first);
            if (firstCode!=0) {
                Object[] pairs = (Object[])entry.getValue();
                System.out.print("    "+firstCode+"=>array(");
                boolean comma = false;
                for (int i=0; i<pairs.length; i+=2) {
                    int secondCode = nameToWinansi((String)pairs[i]);
                    //System.out.println(first+" "+pairs[i]+" "+pairs[i+1]);
                    if (secondCode!=0) {
                        /*
                          System.out.println(
                          firstCode+"("+first+") "+
                          secondCode+"("+pairs[i]+") "+
                        pairs[i+1]);
                        */
                        System.out.print((comma?",":"")+secondCode+"=>"+pairs[i+1]);
                        comma = true;
                    }
                }
                System.out.print(")");
                if (it.hasNext())
                    System.out.println(",");
            }
        }
        System.out.println(");\n?>");
    }

    static int nameToWinansi(String name) {
        return PdfEncodings.unicode2winansi(GlyphList.nameToUnicode(name)[0]);
    }
}
