var selection = null;

function copyPosition(source,dest,full) {
	dest.style.top = source.style.top;
	dest.style.left = source.style.left;
	dest.style.right = source.style.right;
	dest.style.bottom = source.style.bottom;
	if (full) {
		dest.style.width = source.style.width;
		dest.style.height = source.style.height;
	}
}

var selFrame = getElt("selection");

var currentForm = null;
function showBlock(id) {
	var block = getElt(id);
	if (block) {
		block.style.display = "block";
		currentForm = block;
		document.addEventListener("keypress",abortForm,false);
	}
}

function abortForm(event) {
	if (currentForm!=null && event.keyCode == 27) {
		document.removeEventListener("keypress",abortForm,false);
		currentForm.style.display = "none";
		currentForm = null;
		clearSelection();
	}
}

function hideBlock(id) {
	var block = getElt(id);
	if (block) {
		block.style.display = "none";
	}
}

function clearSelection() {
	if (selection!=null) {
		unselect(selection);
	}
}

function select(elt) {
	if (selection==elt) {
		unselect(elt);
	} else {
		unselect(selection);
		//alert("select "+selFrame+" > "+elt);
		elt.parentNode.replaceChild(selFrame,elt);
		selFrame.appendChild(elt);
		selection = elt;
		selFrame.onclick = clearSelection;
		var cl = elt.getAttribute("class");
		if (cl=="image") {
			selFrame.style.position = "absolute";
			copyPosition(elt,selFrame,true);
			elt.style.position = "static";
			selectImage(elt);
		} else if (cl=="text") {
			selFrame.style.position = "absolute";
			copyPosition(elt,selFrame,true);
			elt.style.position = "static";
			selectText(elt);
		} else {
			selectPage(elt);
			selFrame.style.position = "static";
			selFrame.style.width = "auto";
			selFrame.style.height = "auto";
			copyPosition(elt,selFrame,false);
		}
		selFrame.style.display = "block";
	}
	return true;
}

function selectImage(img) {
	showBlock("formEditImage");
	var id = img.id.substring(1);
	window.status = "select image "+id;
	var form = getElt("formEditImage");
	var pageNum = setFormParams(form,img,id);
	updateBox(form,images[pageNum][id]);
	getFormElement(form,"valign").value = images[pageNum][id].valign;
	getFormElement(form,"halign").value = images[pageNum][id].halign;
	setPictureSelectorValue(
		getDescendantByClass(form,"div","pictureSelector"),
		images[pageNum][id].pictureid,
		img.tagName=="DIV" ? img.getElementsByTagName("img")[0] : img);
}

function unselect(elt) {
	if (elt!=null) {
		//alert("unselect "+elt);
		var cl = elt.getAttribute('class');
		if (cl=="image" || cl=="text") {
			elt.style.position = "absolute";
		}
		selFrame.parentNode.replaceChild(elt,selFrame);
		hideBlock("formEditImage");
		hideBlock("formEditText");
		hideBlock("formEditPage");
		selection = null;
		selFrame.onclick = null;
	}
}

function selectPage(page) {
	addClass(selFrame,"fixedSize");
	showBlock("formEditPage");
	var pageNum = getPageNum(page);
	var form = getElt("formEditPage");
	setFormElements(form,"PageNum",pageNum);
	window.status = "selectPage "+pageNum;
}

function getPageNum(pageElt) {
	return pageElt.id.substring(1);
}

function selectText(text) {
	showBlock("formEditText");
	var id = text.id.substring(1);
	window.status = "select text "+id;
	var form = getElt("formEditText");
	var pageNum = setFormParams(form,text,id);
	getFormElement(form,"Text").value = texts[pageNum][id].text;
	getFormElement(form,"Align").value = texts[pageNum][id].align;
	getFormElement(form,"Size").value = texts[pageNum][id].size;
	getFormElement(form,"Font").value = texts[pageNum][id].font;
	updateBox(form,texts[pageNum][id]);
}

function updateBox(form,box) {
	getFormElement(form,"Top").value = box.top;
	getFormElement(form,"Bottom").value = box.bottom;
	getFormElement(form,"Left").value = box.left;
	getFormElement(form,"Right").value = box.right;
}

function getFormElement(form,name) {
	return getDescendantWithAttributeValue(form,"*","name",name);
}

function setFormElements(form,name,value) {
	var elements = getDescendantsWithAttributeValue(form,"*","name",name);
	for (var i=0; i<elements.length; i++) {
		elements[i].value = value;
	}
}

function setFormParams(form,elt,id) {
	setFormElements(form,"Id",id);
	while (elt.getAttribute("class")!="page") {
		elt = elt.parentNode;
	}
	if (elt.getAttribute("class")=="page") {
		var pageNum = getPageNum(elt);
		setFormElements(form,"PageNum",pageNum);
		return pageNum;
	}
}

function click(event) {
	event.stopPropagation();
/*	alert("click "+event.target); */
	return select(event.target);
}

function clickImage(event) {
	event.stopPropagation();
	return select(event.target.tagName=="IMG" ? event.target.parentNode : event.target);
}

function installSelectHandlers(root) {
	var elts = root.getElementsByTagName("*");
	for (var i=0; i<elts.length; i++) {
		var cl = elts[i].getAttribute("class");
		if (cl == "image") 
			elts[i].setAttribute("onclick","return clickImage(event)");
		else if (cl =="text") {
			elts[i].setAttribute("onclick","return click(event)");
		}
	}
}

/*
 * Install event handlers for pages and their elements
 * @param root The root element containing the pages
 * @param tagnmame of page elements
 */
function installPageEvents(root,tagName) {
	var pages = getDescendantsByClass(root,tagName,"page");
	for (var i=0; i<pages.length; i++) {
		pages[i].setAttribute("onclick","return click(event)");
		installSelectHandlers(pages[i]);
	}

	var pages = getDescendantsByClass(root,tagName,"pbox");
	for (var i=0; i<pages.length; i++) {
		var desc = getDescendantByClass(pages[i],"div","desc");
		desc.setAttribute("onclick","return clickPageDesc(event)");
	}
}

function clickPageDesc(event) {
	return select(getDescendantByClass(event.target.parentNode,"div","page"));
}

var texts = new Array();
function Text(id,text,top,left,bottom,right,font,size,align) {
	this.id = id;
	this.text = text;
	this.size = size;
	this.align = align;
	this.top = top;
	this.left = left;
	this.bottom = bottom;
	this.right = right;
	this.font = font;
}

var images = new Array();
function Image(id,pictureid,top,left,bottom,right,halign,valign) {
	this.id = id;
	this.pictureid = pictureid;
	this.valign = valign;
	this.halign = halign;
	this.top = top;
	this.left = left;
	this.bottom = bottom;
	this.right = right;
}

function initSelFrame() {
	selFrame = getElt("selection");
}

var selectedPicture = null;
function pictureSelectorChanged(elt) {
//	alert("pictureSelectorChanged "+elt+" "+elt.id+" "+elt.checked);
	if (selectedPicture!=null) {
		// Mozilla does throw an event when a radio is unselected
		// So we have to workaround this
		var img = selectedPicture.parentNode.getElementsByTagName("img")[0];
		img.setAttribute("class","");
		selectedPicture = null;
	}
	var img = elt.parentNode.getElementsByTagName("img")[0];
	if (elt.checked) {
		img.setAttribute("class","checked");
		selectedPicture = elt;
	} else {
		img.setAttribute("class","");
	}
}

function initPictureSelector() {
	status.window = "initPictureSelector...";
	var list = document.getElementById("pictureList");
	var images = list.getElementsByTagName("img");
	for (i=0; i<images.length; i++) {
		status.window = "init image "+images[i].id;
		images[i].setAttribute("onclick","selectPicture(this);");
	}
	pictureSelectorInitialized = true;
}

var pictureSelectorInitialized = false;
var pictureSelectorTarget = null;
function openPictureSelector(target) {
	if (!pictureSelectorInitialized)
		initPictureSelector();
	pictureSelectorTarget = target;
	var hidden = getDescendantWithAttributeValue(target,"input","name","PictureID");
/*
	if (hidden.value)
		setCurrentPicture(hidden.value);
*/
	var list = document.getElementById("pictureList");
	list.style.display = "block";
	document.addEventListener("keypress",abortPictureSelector,false);
}

function abortPictureSelector(event) {
	if (event.keyCode == 27) {
		document.removeEventListener("keypress",abortPictureSelector,false);
		document.getElementById("pictureList").style.display = "none";		
	}
}

function selectPicture(img) {
	document.getElementById("pictureList").style.display = "none";
	//alert("selectPicture "+img+" "+img.id);
	var pictureid  = img.id.substring(3);
	setPictureSelectorValue(pictureSelectorTarget,pictureid,img);
}

function setPictureSelectorValue(target,pictureid,img) {
	var targetImg = target.getElementsByTagName("img")[0];
	var hscale = (target.offsetWidth-2)/img.width; // -2 is for border width
	var vscale = (target.offsetHeight-2)/img.height;
	var scale = Math.min(hscale,vscale);
	targetImg.src = img.src;
	targetImg.width = img.width*scale;
	targetImg.height = img.height*scale;
	targetImg.style.marginTop = (target.offsetHeight - img.height*scale) / 2 + "px";
	targetImg.setAttribute("alt",img.getAttribute("alt")); 
	var hidden = getDescendantWithAttributeValue(target,"input","name","PictureID");
	hidden.value = pictureid;
}

var currentPicture = null;
function setCurrentPicture(pictureid) {
	if (currentPicture!=null) {
		removeClass(currentPicture,"selected");
	}
	currentPicture = document.getElementById("pic"+pictureid);
	//alert("currentPicture "+pictureid);
	addClass(currentPicture,"selected");
}
// Local Variables:
// tab-width: 4
// End: -->
