<?php
function updateDisplayRatios(&$tof,$overwrite=false) {
	$pictures = $tof->ct->getPictures('PictureID,DisplayRatio,RollID,FrameID');
	foreach($pictures as $picture) {
		updateDisplayRatio($tof,$picture,$overwrite);
	}
}

function updateDisplayRatio(&$tof,$picture, $overwrite) {
	if (!$picture['DisplayRatio'] || $overwrite) {
		$filename = $tof->getOrigFilename($picture);
		if (!file_exists($filename))
			$filename = $tof->getPictureFilename($picture);
		$size = GetImageSize($filename);
		if ($size[1] != 0) {
			$ratio = $size[0] / $size[1];
			$tof->log(
				sprintf('Found size for %s in %s: %dx%d => ratio = %f',
						$picture['PictureID'], $filename, $size[0], $size[1], $ratio));
			$picture['DisplayRatio'] = $ratio;
			$tof->ct->updatePictureFields(
				array('PictureID' => $picture['PictureID'],
					  'DisplayRatio' => $picture['DisplayRatio']));
		} else {
			$tof->warn(
				sprintf('Found invalid size for %s in %s: %dx%d',
						$picture['PictureID'], $filename, $size[0], $size[1]));
		}
	} else {
		$tof->log(
			sprintf(_("Skipping %s, current aspect ratio=%s"),
					$tof->getOrigFilename($picture),
					$picture['DisplayRatio']));
	}
}
?>