<?php
function addGroupsToPictures(&$tof,$groups,$pictures) {
	if (!is_array($groups))
		return;
	foreach($pictures as $pictureID) {
		$picture = $tof->ct->getPicture($pictureID);
		if ($tof->uid == $picture['Owner'] || $tof->isAdmin) {
			$tof->log(sprintf(_('Picture #%s updated'),$pictureID));
			$tof->ct->addGroupsToPicture(
				$pictureID,$groups,$tof->uid);
		} else {
			$tof->warn(
				sprintf(_('Picture #%s not updated: You cannot change the groups of a picture that you do not own'),$pictureID));
		}
	}
}

function removeGroupsFromPictures(&$tof,$groups,$pictures) {
	if (!is_array($groups))
		return;
	foreach($pictures as $pictureID) {
		$picture = $tof->ct->getPicture($pictureID);
		if ($tof->uid == $picture['Owner']) {
			$tof->log(sprintf(_('Picture #%s updated'),$pictureID));
			$tof->ct->removeGroupsFromPicture($pictureID,$groups);
		} else {
			$tof->warn(
				sprintf(_('Picture #%s not updated: You cannot change the groups of a picture that you do not own'),$pictureID));
		}
	}
}


/* private : delete a group, if user has the right to do this */
function deleteGroup(&$tof,$groupID) {
	$group = $tof->ct->getGroup($groupID);
	if ($group['Owner']==$tof->uid) {
		$tof->ct->deleteGroup($groupID);
		$tof->log(sprintf(_('Group "%s" deleted'),$group['Name']));
	} else {
		$tof->log(_('You cannot delete a group that you do not own'));
	}
}

function updateGroup(&$tof,$group,$users) {
	$lGroup = $tof->ct->getGroup($group['GroupID']);
	if ($tof->uid==$lGroup['Owner']) {
		$tof->ct->updateGroup($group,$users);
	} else {
		$tof->error(_('You cannot modify a group that you do not own.'));
	}
}
?>