<?php
function _deletePicture(&$tof,$vars) {
	deletePicture($tof,$vars['PictureID'],$vars['DeleteFiles']);
}

function deletePicture(&$tof,$pictureOrID,$deleteFiles) {
	if (!is_array($pictureOrID)) {
		$pictureID = $pictureOrID;
		$picture = $tof->ct->getPicture($pictureID);
	} else {
		$picture = $pictureOrID;
		$pictureID = $picture['PictureID'];
	}
	$tof->debug("deletePicture ".$pictureOrID." -> ".$pictureID);
	if (!is_array($picture)) {
		$tof->error(sprintf(_("Picture %s not found !!!"),$pictureID));
		return;
	}
	if ($picture['Owner'] != $tof->uid) {
		$tof->error(
			sprintf(
				_('You cannot delete a picture that you do not own (PictureID=%s,FrameID=%s/%s)'),
				$pictureID,$picture['RollID'],$picture['FrameID']));
		return;
	}
	$tof->ct->deletePicture($pictureID);
	if ($deleteFiles) {
		deleteFiles($tof,$picture);
	}
}

function deleteFiles(&$tof,$picture) {
	require_once("actions/disk_usage.php");
	increaseDiskUsage(
		$tof,
		$picture['Owner'],
		- getPictureDiskUsage($tof,$picture));
	unlink($tof->getOrigFilename($picture));
	unlink($tof->getPictureFilename($picture));
	unlink($tof->getThumbFilename($picture));
}
?>