<?php
function _changePicture(&$tof,$vars) {
	changePicture($tof,$vars['PictureID'],$_FILES['file']['tmp_name']);
}

function changePicture(&$tof,$pictureID,$file) {
	require_once("actions/uploads.php");
	require_once("actions/disk_usage.php");
	require_once("actions/thumb.php");

	$tof->debug("changePicture $pictureID $file");

	$picture = $tof->ct->getPicture($pictureID);
	if (!$picture) {
		$tof->error(sprintf(_('No such picture: %s'),$pictureID));
	} else if ($picture['Owner']!=$tof->uid) {
		$tof->error(sprintf(_('You cannot modify a picture that you do not own (%s)'),
							$pictureID));
	} else {
		$size = getPictureDiskUsage($tof,$picture);
		increaseDiskUsage($tof,$tof->uid,-$size);

		$dest = $tof->getOrigFilename($picture);
		$tof->debug("changePicture $pictureID $file -> $dest");
		if (!copy($file,$dest)) {
			$tof->error(sprintf(_('Failed to copy file to %s'),$dest));
			return;
		}
		if (!chmod($dest,0660)) { 
			$tof->error(sprintf(_('Failed to change file access permissions for \'%s\''),$dest));
		}
		createThumb($tof,$picture,true);
		$user = $tof->user;
		if ($user['Quota'] && $user['DiskUsage'] + $size > $user['Quota']) {
			$tof->warn(_('Quota exceeded'));
		}

		$size = getPictureDiskUsage($tof,$picture);
		increaseDiskUsage($tof,$tof->uid,$size);
	}
}
?>