<?php // -*- mode: php -*-

if (!isset($output_separator)) {
	$output_separator = '&amp;';
}

class BasicRender {

	//var $slooze;
  var $nl = "\n";              /* newline sequence */
  var $htmlStr;   /* string to return for output to browser */
  var $htmlHeader = "";
  var $logStr = "";
  var $debugStr = "";
  var $errorStr = "";
  var $warnStr = "";
  var $anonymous;
  var $uid;
  var $ct;
  var $selection;	/* the selected set of pictures (a roll, a topic ...) */
  var $userSelection;	/* the users selection */
  var $view;		/* the current page view (a picture, thumbs ...) */
  var $links = array(); /* navigational links: relname => url */
  var $htmlTitle;	/* the <html> title tage */
  var $topTitle; 	/* the title that will show at the top of the page */
  var $showSort = true;
  var $showMode = true;
  var $showNbThumbs = true;

  // Base path to use when generating links
  var $context;

  // Session variables (editable by the user)
  var $displayMode = 'normal'; /* the current display mode */
  var $nbThumbsPerPage = 8; /* the number of thumbnails to display per page */
  var $recursiveTopic = false; /* display pictures of subtopics in the topic */
  var $hideTopics = false;
  var $showEmptyTopics = false;
  var $thumbScale = 1;
  var $showThumbCB = true;
  var $showThumbDate = true;
  var $showThumbTitle = true;
  var $showTooltips = true;
  var $authorFilter = ""; /* only select pictures from this author */
  var $showTooltips = true;
  var $pageScale = 0.7;
  var $pictureInterval = 5;

  // Internal session variables (NOT editable by the user)
  var $admin = false; /* Wether we are in admin mode */
  var $isAdmin = false; /* Wether the user is an admin */

  var $showInHeader = false; /* wether show() appends data to htmlHeader */
  var $output_separator;
  var $debug = false;
  var $charset = 'iso-8859-1';
  var $version = '1.6.1';
  var $modes = array();
  var $keywordScript = false;
  var $useCSS = true;
  var $stylesheets = array();
  var $embeddedCSS = '';
  var $onload = '';
  var $scripts = array();
  var $style;

  var $sessionParameters = 
	  array('Count' => 'nbThumbsPerPage',
			'SortMethod' => 'sortMethod',
			'DisplayMode' => 'displayMode',
			'AuthorFilter' => 'authorFilter',
			'RecursiveTopic' => 'recursiveTopic',
			'HideTopics' => 'hideTopics',
			'ThumbScale' => 'thumbScale',
			'ShowThumbCB' => 'showThumbCB',
			'ShowThumbTitle' => 'showThumbTitle',
			'ShowThumbDate' => 'showThumbDate',
			'ShowTooltips' => 'showTooltips',
			'PageScale' => 'pageScale',
			'PictureInterval' => 'pictureInterval',
			'ShowEmptyTopics' => 'showEmptyTopics');

  function BasicRender(&$slooze) {
	  $this->slooze = &$slooze;
	  $this->updateUserInfo();
	  $this->modes = array('diaporama' => _('Slide show'),
						   'normal' => _('Normal'),
						   'detail' => _('Detailed'),
						   'pages' => _('Pages'));

	  global $output_separator,$charset;
	  $this->output_separator = $output_separator;

	  if (isset($charset))
		  $this->charset = $charset;

	  $this->permNames = 
		   array(WRITE => _('write'),
				 READ => _('read'),
				 DELETE => _('delete'),
				 OWNER => _('owner'));

	  $this->context = $_SERVER['PHP_SELF'];
  }

  function updateUserInfo() {
	  $this->anonymous = $this->slooze->anonymous;
	  $this->uid = $this->slooze->uid;
	  $this->ct = &$this->slooze->ct;
	  $this->admin = $this->slooze->admin;
	  $this->user = &$this->slooze->user;
	  $this->canSelect = $this->slooze->canSelect;
	  $this->isAdmin = $this->slooze->isAdmin;
  }

  function actionAndViewURL($params="") {
	  global $sess;
	  if (is_array($params))
		  $params = $this->build_qs($params);
	  if ($params!="" && $this->view!="") {
		  $params .= $this->output_separator;
	  }
	  $params .= $this->view;
	  
	  if ($params != "") {
		  return $sess->url($this->context . "?" . $params);
	  } else {
		  return $sess->url($this->context);
	  }
  }

  function actionURL($params="") {
	  global $sess;
	  
	  if (is_array($params))
		  $params = $this->build_qs($params);
	  if ($params) {
		  return $sess->url($this->context . "?" . $params);
	  } else {
		  return $sess->url($this->context);
	  }
  }

  function selectURL($params="") {
	  global $sess;
	  if ($params!="" && $this->selection!="") {
		  $params .= $this->output_separator;
	  }
	  $params .= $this->selection;
	  if ($params != "") {
		  return $sess->url($this->context . "?" . $params);
	  } else {
		  return $sess->url($this->context);
	  }
  }

  /** the current script URL */
  function selfURL($params="") {
	  global $sess;
	  if ($params != "") {
		  return $sess->url($this->context . "?" . $params);
	  } else {
		  return $sess->url($this->context);
	  }
  }

  function url($url) {
	  global $sess;
	  return $sess->url($url);
  }

  function filterSelfUrl($toremove) {
	  global $sess;
	  return $sess->self_url($toremove);	  
  }

  function urlWithParams($url,$params,$separator=false) {
	  if (!$separator)
		  $separator = $this->output_separator;
	  global $sess;
	  $p = array();
	  foreach($params as $name => $value) {
		  $p[] = "${name}=".urlencode($value);
	  }
	  return $sess->url($url.'?'.join($separator,$p));
  }

  function showHeader() {
	  $this->show(<<<EOT
<!doctype html public "-//W3C//DTD HTML 4.01//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset={$this->charset}">
EOT
	  );
	  $title = $this->admin ? _('Admin photo') : _('Photo album');
	  if (isset($this->htmlTitle)) {
		  $title .= " : ".$this->htmlTitle;
	  }
	  $user_agent = $_SERVER['HTTP_USER_AGENT'];
	  $this->show("<title>$title</title>");
	  if ($this->useCSS) {
		  $this->show('<link rel="stylesheet" type="text/css" media="all" href="all.css">');
		  // special style-sheet for netscape 4.x
		  $this->debug("HTTP_USER_AGENT=$user_agent");
		  if (ereg("^Mozilla/4.*",$user_agent) && 
			  ! ereg("MSIE",$user_agent)) {
			  $this->show('<link rel="stylesheet" type="text/css" href="netscape.css">');
		  } else {
			  $this->show('<link rel="stylesheet" type="text/css" media="screen" href="style.css">');
		  }
		  
		  if (ereg("MSIE",$user_agent)) {
			  $this->show('<link rel="stylesheet" type="text/css" media="screen" href="ie.css">');
		  }
		  $this->show('<link rel="stylesheet" type="text/css" media="print" href="print.css">');
		  foreach($this->stylesheets as $css) {
			  $this->show("<link rel=\"stylesheet\" type=\"text/css\" href=\"$css\">");
		  }
		  if ($this->style) {
			  $this->show("<style type=\"text/css\">\n".$this->style.'</style>');
		  }
	  }

	  foreach($this->links as $rel => $url) {
		  $this->show("<link rel=\"$rel\"  href=\"$url\">");
	  }

	  foreach($this->scripts as $script) {
		  $this->includeJavaScript($script);
	  }
	  $this->show("<script type=\"text/javascript\">var context = '{$this->context}';</script>");
	  $this->show("</head>\n<body".($this->onload!="" ? " onload=\"{$this->onload}\"":"").">");
  }

  function showMessages() {
	  if ($this->logStr!="") {
		  echo '<div class="log" id="log" ondblclick="undisplayElt(\'log\')">'.
			  $this->logStr."</div>\n";
	  }
	  if ($this->debugStr!="" && $this->debug) {
		  echo '<div class="debug">'.
			  $this->debugStr."</div>\n";
	  }
	  if ($this->errorStr!="") {
		  echo '<div class="error"><div class="title">'._('ERROR').'</div>'.
			  $this->errorStr."</div>\n";
	  }
	  if ($this->warnStr!="") {
		  echo '<div class="warn"><div class="title">'._('WARNING').'</div>'.
			  $this->warnStr."</div>\n";
	  }
  }

  /* High-level functions to render page bodies */

  function getParentTopics($topics) {
	  $result = array();
	  foreach($topics as $topic) {
		  while($topic['TopicID']!=0) {
			  $result[$topic['TopicID']] = $topic;
			  $topic = $this->ct->getTopic($topic['ParentTopicID']);
		  }
	  }
	  return $result;
  }

  /* private: add a string to the html to be returned */
  function show($msg, $nl = true) {
	  if ($this->showInHeader) {
		  $this->showH($msg,$nl);
	  } else {
		  $this->htmlStr .= $msg;
		  if ($nl) {
			  $this->htmlStr .= $this->nl;
		  }
	  }
  }

  /* private: add a string to the html header to be returned */
  function showH($msg, $nl = true) {
	  $this->htmlHeader .= $msg;
	  if ($nl) {
		  $this->htmlHeader .= $this->nl;
	  }
  }

  function getUserSelection() {
	  if (!is_array($this->userSelection))
		  $this->userSelection = $this->ct->getSelection($this->uid);
  }

  function getAllTopics() {
	  if ($this->topics==NULL)
		  $this->topics = $this->ct->getAll('topics','*','Description');
	  return $this->topics;
  }

  function getAllTopicsWithPerms($perms='') {
	  $topics = $this->getAllTopics();
	  if ($perms) {
		  $ids = $this->ct->getTopicIDs($this->uid,$perms);
		  foreach($topics as $topic) {
			  if (isset($ids[$topic['TopicID']]))
				  $result[] = $topic;
		  }
		  return $result;
	  } else {
		  return $topics;
	  }
  }

  /* build a query string from an array, filtering out "again" and
     "logout" values */
  function build_qs($vars,$allowEmpty=false) {
	  $querystring = "";
	  if (is_array($vars)) {
		  reset($vars);
		  while( list($var, $value) = each($vars) ) {
			  if ($var != "again" && $var != "logout" && 
			      $var != "username" && $var != "password" &&
			      $var != "submit") 
			  {
				  if (is_array($value)) {
					  reset($value);
					  while( list($var2, $value2) = each($value) ) {
						  if ($querystring!="") {
							  $querystring .= $this->output_separator;
						  }
						  $querystring .= $var."[]=".$value2;
					  }
				  } else if ($value !== "") {
					  if ($querystring != "") {
						  $querystring .= $this->output_separator;
					  }
					  $querystring .= "$var=".urlencode($value);
				  } else if ($allowEmpty) {
					  if ($querystring != "") {
						  $querystring .= $this->output_separator;
					  }
					  $querystring .= "$var";
				  }
			  }
		  }
	  }
	  return $querystring;
  }

  function setView($vars,$allowEmpty=false) {
	  $this->view = $this->build_qs($vars,$allowEmpty);
	  $this->links['normalView'] = $this->actionAndViewURL('DisplayMode=normal');
  }

  function setSelection($vars,$allowEmpty=false) {
	  $this->selection = $this->build_qs($vars,$allowEmpty);
  }

  function setTitle($title) {
	  $this->htmlTitle = $title;
	  $this->topTitle = $title;
  }

  function setBareTitle($title) {
	  $this->htmlTitle = $title;
	  $this->topTitle = $title;
	  $this->setNoDisplayPrefs();
  }

  function setNoDisplayPrefs() {
	  $this->showMode = false;
	  $this->showNbThumbs = false;
	  $this->showSort = false;
  }

  function formatYesNo($boolean) {
	  return $boolean ? _('yes') : _('no');
  }

  function getTopicLink($text,$topicID) {
	  return $this->slooze->getTopicLink($text,$topicID);
  }

  function includeJavaScript($src) {
	  $this->show("<script src=\"$src\" type=\"text/javascript\"></script>");
  }

  function startJavaScript() {
	  $this->show('<script type="text/javascript">');
  }

  function endJavaScript() {
	  $this->show('</script>');
  }

  function showJavaScript($script) {
	  $this->startJavaScript();
	  $this->show($script);
	  $this->endJavaScript();
  }

  /* private: add a string to the html to be returned */
  function error($msg) {
	  if (!strlen($msg))
		  $msg = _('something went wrong'); // no error message set
	  $this->errorStr .= $msg.'<br>';
  }

  function warn($msg) {
	  $this->warnStr .= $msg.'<br>';
  }

  function log($msg) {
	  $this->logStr .= $msg.'<br>';
  }

  function debug($msg) {
	  if ($this->debug)
		  $this->debugStr .= $msg.'<br>';
  }

  function flushPage() {
	  $this->showInHeader=true;
	  $this->showHeader();
	  echo $this->htmlHeader;
	  echo $this->htmlStr;
	  echo '</body>';
	  echo '</html>';
  }

  function hasTopicPerm($topicID,$perm) {
	  return in_array($perm,$this->ct->getTopicPerms($topicID,$this->uid));
  }

  function hasTopicPerms($topicID,$perms) {
	  $actualPerms = $this->ct->getTopicPerms($topicID,$this->uid);
	  foreach($perms as $perm) {
		  if (in_array($perm,$actualPerms))
			  return true;
	  }
	  return false;
  }
}

function debug($msg) {
	global $myRender;
	if ($myRender)
		$myRender->debug($msg);
	else
		print($msg);
}

function quote($string) {
	return '"'.$string.'"';
}

## Local Variables:
## tab-width: 4
## End:
?>
