<?php // -*- mode: php -*-
/*
 * Slooze PHP Web Photo Album
 * Copyright (c) 2000 Matthew Kendall, Laurent Martelli
 * $Id: slooze_local.php,v 1.1 2005/04/23 15:45:04 lmartelli Exp $
 *
 * Local customisations - edit this file only
 * Uncomment and edit as required
 */ 

/* --------
 * To store data in an RDBMS use slooze_ct_sql and whichever db_*.inc
 * is applicable for your particular database. Uncomment as required.
 * Get the db_*.inc files from PHPLib - http://phplib.netuse.de/  */
 
require("timer.php");
$timer = new Timer;

$snapshots = array();
function snapshot($name) {
	global $snapshots,$timer;
	$snapshots[] = array(
		'name'=>$name,
		'time'=>$timer->show(),
		'memory'=>memory_get_usage());
}
function showSnapshots(&$render) {
	global $snapshots;
	foreach($snapshots as $snap) {
		$render->log("${snap['name']}: ${snap['time']}s, ".makeSizeString($snap['memory']));
	}
}
snapshot('start');

$sqlTimer = new Timer(false);
//$mem[] = memory_get_usage();

require("slooze_ct_sql.php");
snapshot('slooze_ct_sql.php');
require("db_pgsql.php");
snapshot('db_pgsql.php');

require("page.php");
snapshot('page.php');
require("session.php");
snapshot('session.php');
require("auth.php");
snapshot('auth.php');
require("ct_sql.php");
snapshot('ct_sql.php');

require("tof_auth.php");
require("tof_session.php");

// Set to "&amp;" or ";" if you want really validating html to be generated
// You should then use `` arg_separator.input = ";&" '' in you php.ini
$output_separator = "&amp;";

class MySloozeCtSql extends SloozeCtSql {
  var $sqlClass = "MyDB_Sql";  /* type of RDBMS data store */
  /* public: constructor, call parent constructor */
  function MySloozeCtSql() {
    $this->SloozeCtSql();
  }
}
snapshot('My*');

/* --------
 * Always include slooze
 * Uncomment the $ctClass line below that applies to you */

require("slooze.php");
snapshot('slooze.php');
require("slooze_render.php");
snapshot('slooze_render.php');

require("config.php");

class My_CT_Sql extends CT_Sql {
	var $classname = "My_CT_Sql";
	var $database_table = "active_sessions";
	var $database_class = "MyDB_Sql";
}

snapshot('slooze_local.php');
?>
