<?php

function showTopicSummary(&$render,$topic) {
	if (strlen($topic['Summary']))
		$render->show('<p class="topicdesc">'.$topic['Summary'] . '</p>');
}


/* render a page body for a given topic */
function renderTopic(&$render,$topicID, $start=0) {
	require_once("render/thumb.php");
	require_once("render/header.php");
	require_once("render/navbar.php");

	$render->setSelection(array('TopicID' => $topicID));
	$render->setView(array('TopicID' => $topicID,
						   'Start' => $start));
	$render->currentTopicID = $topicID;
	$render->showRecursiveTopic = true;

	$topic = $render->ct->getTopic($topicID);
	if (!$topic) {
		$render->error(sprintf(_('No such album %d'),$topicID));
		showNavBar($render);
		return;
	}

	if ($render->uid!=1 && !$render->hasTopicPerms($topicID,array(OWNER,READ))) {
		$render->error(
			sprintf(_('You do not have the right to see the album "%s"'),
					$topic['Description']));
		showNavBar($render);
		return;
	}

	if ($topic['Book'] && $render->displayMode=='pages') {
		require_once("render/book.php");
		renderBook($render,$topicID,$topic,$start);
		return;
	}

	if ($render->nbThumbsPerPage>0) {
		$pictures = 
			 $render->ct->getPicturesInTopic(
				 $topicID,$render->recursiveTopic,
				 $render->uid,
				 $start,$render->nbThumbsPerPage,$count);
	}
	$render->count = $count;

	$render->htmlTitle = $topic['Description'].countString($render,$start,$count);
	// header
	$render->topTitle = 
		 $topic['Description'] . countString($render,$start,$count);

	$render->show('<div class="normal">');
	if ($render->admin) {
		require_once("render/admin.php");
		showFormAdminActions($render);
	}

	showTopicSummary($render,$topic);

	// subtopics
	showSubTopics($render,$topicID);
	// thumbs
	if ($topicID!=0) {
		$topic = $render->ct->getTopic($topicID);
		$upLink = "TopicID=".$topic['ParentTopicID'];
		$parentTopic = $render->ct->getTopic($topic['ParentTopicID']);
		$upTitle = $parentTopic['Description'];
	} else {
		$upLink = '';
		$upTitle = '';
	}
	showThumbs(
		$render,
		$pictures,$start,$count,
		$upLink,$upTitle);

	// other
	if ($topicID != 0) {
		require_once("render/nav.php");
		showNav($render,$topicID);
	}
	if (!$render->anonymous) {
		$render->show('<p>',false);
		require_once("render/actions.php");
		showLink(
			$render,
			_('Gen PDF'),'genTopicPdf',_('Generate a PDF file'),
			array('TopicID'=>$topicID));
		$render->show('</p>');
	}
	if ($render->admin) {
		require_once("render/form_topic.php");
		showFormAdminActions($render);
		showFormMissingFiles($render);
		$perms = $render->ct->getTopicPerms($topicID,$render->uid);
		$topic = $render->ct->getTopic($topicID);
		if ($render->uid==1 || in_array(WRITE,$perms) || in_array(OWNER,$perms)) {
			showFormUpdateTopic($render,$topic);
			showUploadTopic($render,$topic);
			showAddTopic($render,$topic);
			showAddSelectionToTopic($render,$topic);
		}
		if ($render->uid==1 || in_array(DELETE,$perms) || in_array(OWNER,$perms))
			showFormDeleteTopic($render,$topicID);
		if ($render->uid==1 || in_array(OWNER,$perms))
			showFormUpdateTopicPerms($render,$topic);
	}
	$render->show("</div>");
}

function showShowHideTopics(&$render) {
	require_once("render/actions.php");
	if ($render->hideTopics) {
		showLink($render,_('show albums'),'showHideTopics','',array(),'showHideTopics',true);
	} else {
		showLink($render,_('hide albums'),'showHideTopics','',array(),'showHideTopics',true);
	}
}

/**
 * Show a list of subtopics for topic
 */
function showSubTopics(&$render,$parentTopicID) {
	/*
	  $subTopics = $render->ct->getSubTopics($topicID);
	  showTopics($subTopics);
	*/
	$topics = $render->ct->countPicturesInSubtopics($parentTopicID,$render->uid,array(OWNER,READ));
	if (count($topics)==0)
		return;
	if ($render->recursiveTopic) {
		showShowHideTopics($render);
		$render->show(
			'<ul id="topics" class="topics'.(count($topics)>5?' floatLeft':'').'"'.
			($render->hideTopics?' style="display: none"':'').
			'>');
		foreach($topics as $topic) {
			if ($render->showEmptyTopics || $topic['count']>0) {
				$render->show(
					'<li'.($topic['Book']?' class="book"':'').'>'.
					"<a href=\"".
					$render->selfURL("TopicID=".$topic['TopicID']).
					"\">".
					$topic['Description']." [".$topic['count']."]</a>".
					"</li>");
			}
		}
		$render->show("</ul>");
	} else {
		foreach($topics as $topic) {
			if ($render->showEmptyTopics || $topic['count']>0) {
				//$render->show($picture['PictureID']."<br>\n");
				$front = $render->ct->getTopicFrontPage($topic['TopicID'],true,$render->uid);
				if (!$front) {
					$front = $render->ct->getBestPictureInTopic(
						$topic['TopicID'],true,$render->uid);
				}
				showTopicThumb(
					$render,
					$topic,
					$front,
					$render->selfURL("TopicID=".rawurlencode($topic['TopicID'])));
			}
		}
	}
}

function showTopicThumb(&$render, $topic, $picture, $url) {
	require_once("render/thumb.php");
	$fileName = $render->slooze->getThumbFilename($picture);
	// the float way
	$render->show('<a href="'.$url.'"><div class="thumb topic"><div class="pic">');
	if (file_exists($fileName)) {
		showThumbImg($render,$picture,'');
	} else if ($picture) {
		$render->error(
			$render->getTopicLink(
				sprintf(_("Album %s (%s)"),$topic['Description'],$topic["TopicID"]),
				$topic["TopicID"]
			).
			" : <a href=\"" .
			$render->selectURL("PictureID=".$picture['PictureID'].
							 $render->output_separator."Position=$position").
			"\">".sprintf(_('File not found : %s'),$fileName)."</a>");
	}

	$render->show('</div>');
	$render->show('<div class="desc">'.
				  $topic['Description'].' ('.$topic['count'].')'.
				  '</div>');
	$render->show("</div></a>");
}

/** Render a page body for a given picture */
function renderPictureInTopic(&$render, $pictureID, $topicID, $position) {
	require_once("render/picture.php");
	require_once("render/navbar.php");

	$render->setSelection(array('TopicID' => $topicID));
	$render->setView(array('TopicID' => $topicID,
						   'PictureID' => $pictureID,
						   'Position' => $position));
	$pictures =
		 $render->ct->getPictureInTopic(
			 $pictureID, $topicID,
			 $render->recursiveTopic,
			 $position, $render->uid);
	if ($pictures) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	} else {
		$topic = $render->ct->getTopic($topicID);
		$render->error(
			sprintf(_('The picture you selected is not visible in the album "%s".'),
					$topic['Description']));
		showNavBar($render);
	}
}
?>